/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.config;

import bee.cloud.engine.db.core.CBase;
import bee.cloud.service.filter.BeeHandlerInterceptorAdapter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.NumericNode;
import java.io.IOException;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
public class WebMvcConfiguration
implements WebMvcConfigurer {
    @Autowired
    private BeeHandlerInterceptorAdapter adapter;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter jackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule simpleModule = new SimpleModule();
        LongSerialize ls = new LongSerialize();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ls);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ls);
        simpleModule.addSerializer(NumericNode.class, (JsonSerializer)new NumericNodeSerialize());
        simpleModule.addSerializer(CBase.class, (JsonSerializer)new CBaseSerialize());
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
        jackson2HttpMessageConverter.setObjectMapper((ObjectMapper)objectMapper);
        converters.add(0, (HttpMessageConverter<?>)jackson2HttpMessageConverter);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        AntPathMatcher matcher = new AntPathMatcher();
        matcher.setCaseSensitive(false);
        configurer.setPathMatcher((PathMatcher)matcher);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.adapter);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(mapper);
        return converter;
    }

    public class CBaseSerialize
    extends JsonSerializer<CBase> {
        public void serialize(CBase value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                gen.writeObject((Object)value.outMap());
            }
        }
    }

    public class JacksonObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = -8323827540513691231L;

        public JacksonObjectMapper() {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            this.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            SimpleModule simpleModule = new SimpleModule();
            LongSerialize ls = new LongSerialize();
            simpleModule.addSerializer(Long.class, (JsonSerializer)ls);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ls);
            simpleModule.addSerializer(CBase.class, (JsonSerializer)new CBaseSerialize());
            this.registerModule((Module)simpleModule);
        }
    }

    public class LongSerialize
    extends JsonSerializer<Long> {
        public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                if (value > 922337203685477L || value < -922337203685477L) {
                    gen.writeString(value.toString());
                } else {
                    gen.writeNumber(value.longValue());
                }
            }
        }
    }

    public class MultipartFileSerialize
    extends JsonSerializer<MultipartFile> {
        public void serialize(MultipartFile value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                gen.writeObject((Object)value.getOriginalFilename());
            }
        }
    }

    public class NumericNodeSerialize
    extends JsonSerializer<NumericNode> {
        public void serialize(NumericNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                long v = value.asLong();
                if (v > 922337203685477L || v < -922337203685477L) {
                    gen.writeString("" + v);
                } else {
                    gen.writeNumber(v);
                }
            }
        }
    }
}

