/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service;

import bee.cloud.core.Bee;
import bee.cloud.service.base.work.Work;
import bee.cloud.service.filter.BeeFilter;
import bee.tool.Tool;
import bee.tool.string.Format;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.bind.annotation.RestController;

@ComponentScan(basePackages={"bee.cloud.**", "bee.service.**"})
public class BeeApplication {
    public static ConfigurableApplicationContext run(String[] args) {
        String path;
        String metapath;
        StackTraceElement[] stacks;
        Work.setStartTime((long)System.currentTimeMillis());
        Class<?> primaryClass = null;
        StackTraceElement[] stackTraceElementArray = stacks = Thread.currentThread().getStackTrace();
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stack = stackTraceElementArray[n2];
            String name = stack.getClassName();
            if (!"java.lang.Thread".equals(name)) {
                try {
                    Class<?> clz = Class.forName(stack.getClassName());
                    Work.clazzs.add(clz);
                    Work.pkgs.add(clz.getPackage().getName());
                    primaryClass = clz;
                }
                catch (Exception clz) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (primaryClass != null) {
            Work.clazzs.remove(primaryClass);
            Work.clazzs.add(0, primaryClass);
        }
        if (Format.noEmpty((Object)(metapath = BeeApplication.toMetaPath(path = primaryClass.getProtectionDomain().getCodeSource().getLocation().getPath())))) {
            System.setProperty("config.metapath", metapath);
        }
        try {
            Class<?> clz = Class.forName("bee.service.config.NacosClient");
            Work.clazzs.add(clz);
            Work.pkgs.add("bee.cloud.service.feign.config");
            Work.pkgs.add(clz.getPackage().getName());
        }
        catch (Exception clz) {
            // empty catch block
        }
        Work.clazzs.add(BeeApplication.class);
        String pkg = BeeApplication.class.getPackage().getName();
        Work.pkgs.add(pkg);
        SpringApplication root = new SpringApplication(new Class[]{BeeApplication.class});
        Work.clazzs.add(BeeFilter.class);
        root.addPrimarySources((Collection)Work.clazzs);
        root.setSources(Work.pkgs);
        ConfigurableApplicationContext ctx = root.run(args);
        String appName = ctx.getEnvironment().getProperty("spring.application.name");
        Thread.currentThread().setName(appName);
        System.setProperty("app.name", appName);
        String[] beanNamesForAnnotation = ctx.getBeanNamesForAnnotation(RestController.class);
        Tool.Log.info((Object)beanNamesForAnnotation);
        String[] stringArray = beanNamesForAnnotation;
        int n3 = beanNamesForAnnotation.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray[n4];
            Class<?> cls = ctx.getBean(name).getClass();
            Work.clazzs.add(cls);
            ++n4;
        }
        ComponentScan scan = primaryClass.getAnnotation(ComponentScan.class);
        if (scan != null) {
            String[] stringArray2 = scan.value();
            int n5 = stringArray2.length;
            n3 = 0;
            while (n3 < n5) {
                String pck = stringArray2[n3];
                Work.pkgs.add(pck.replace(".**", "").replace(".*", ""));
                ++n3;
            }
            stringArray2 = scan.basePackages();
            n5 = stringArray2.length;
            n3 = 0;
            while (n3 < n5) {
                String pck = stringArray2[n3];
                Work.pkgs.add(pck.replace(".**", "").replace(".*", ""));
                ++n3;
            }
        }
        Work.init((ApplicationContext)ctx);
        return ctx;
    }

    private static String toMetaPath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        String metapath = String.valueOf(file.getParent()) + File.separator + "META-INF";
        File metafile = new File(metapath);
        if (metafile.exists()) {
            return String.valueOf(metapath) + File.separator;
        }
        return BeeApplication.toMetaPath(file.getParent());
    }

    public static void addSources(Class<?> sources) {
        Work.clazzs.add(sources);
    }

    public static void addSources(String packageName) {
        Work.pkgs.add(packageName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addFactories(Class<?> primaryClass) {
        URL resource = primaryClass.getResource("/");
        Tool.Log.info((String)">>>>>resource:{}", (Object[])new Object[]{resource});
        if (resource == null) {
            resource = primaryClass.getResource("");
        }
        String path = resource.getPath();
        String config = "org.springframework.boot.env.PropertySourceLoader=\\org.springframework.boot.env.MyPropertiesPropertySourceLoader";
        if ("jar".equals(resource.getProtocol())) {
            String jarFileName = path.substring(path.indexOf("/") + 1, path.indexOf("!/"));
            if (Tool.isWindows() && jarFileName.startsWith("/")) {
                jarFileName = jarFileName.substring(1);
            }
            Tool.Log.info((String)">>>>>jarFileName:{}", (Object[])new Object[]{jarFileName});
            String metaInfFilePath = "META-INF/spring.factories";
            try {
                Throwable throwable = null;
                Object var7_12 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(jarFileName);
                    try {
                        try (JarArchiveOutputStream jos = new JarArchiveOutputStream((OutputStream)fos);){
                            JarArchiveEntry entry = new JarArchiveEntry(metaInfFilePath);
                            jos.putArchiveEntry((ArchiveEntry)entry);
                            jos.write(config.getBytes());
                            jos.closeArchiveEntry();
                            jos.finish();
                        }
                        if (fos == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        String sfile = Tool.isWindows() && path.startsWith("/") ? path.substring(1) : path;
        File file = new File(String.valueOf(sfile) + "/META-INF/spring.factories");
        if (file.exists()) {
            return;
        }
        try {
            Tool.FileOperate.write((File)file, (String)config);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void started() {
        InputStream is = BeeApplication.class.getResourceAsStream("bee.logo");
        StringBuffer readFile = Tool.FileOperate.readFile((InputStream)is);
        System.out.println(readFile);
        Bee.started();
    }

    public static <T extends Work.WInit> void addBinit(Class<T> binit) {
        Work.binits.add(binit);
    }

    public static void main(String[] args) {
        BeeApplication.started();
    }
}

