/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.filter;

import bee.cloud.core.Bee;
import bee.cloud.core.db.BusinessManage;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.core.HttpParam;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.error.ExcHandler;
import bee.cloud.service.work.Respond;
import bee.tool.err.BeeException;
import bee.tool.string.Format;
import bee.tool.string.MD5;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=-10)
@WebFilter(filterName="beeFilter", urlPatterns={"/*"})
public class BeeFilter
implements Filter {
    @Autowired
    private ExcHandler handler;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Thread.currentThread().setName("bee_" + Thread.currentThread().getId());
            if (!Bee.isStarted()) {
                Results results = new Results();
                results.setResponse((HttpServletResponse)response);
                results.warning((Object)"\u7cfb\u7edf\u6b63\u5728\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01").build();
                return;
            }
            String encode = request.getCharacterEncoding();
            response.setContentType("application/json;charset=" + encode);
            response.setCharacterEncoding(encode);
            BusinessManage bm = BusinessManage.inst();
            Respond resreq = new Respond((HttpServletResponse)response, (HttpServletRequest)request);
            bm.setResponse((Bee.Resreq)resreq);
            HttpParam httpParam = new HttpParam((HttpServletRequest)request);
            RequestParam rparam = httpParam.getRParam();
            bm.setRequestParam(rparam);
            if (!this.check()) {
                Results results = new Results();
                results.setResponse((HttpServletResponse)response);
                results.warning((Object)"\u975e\u6cd5\u8bbf\u95ee\uff01\u5c0f\u6837\uff0c\u4f60\u4ee5\u4e3a\u6362\u4e86\u4e2a\u9a6c\u7532\u6211\u5c31\u4e0d\u8ba4\u8bc6\u4f60\u4e86\u3002").build();
                return;
            }
            try {
                try {
                    chain.doFilter(request, response);
                }
                finally {
                    bm.clear();
                }
            }
            catch (BeeException e) {
                Map<String, Object> map = this.handler.errorHandler((Exception)((Object)e));
                Results results = new Results();
                results.setResponse((HttpServletResponse)response);
                results.putAll(map);
                results.build();
                return;
            }
        }
        finally {
            BusinessManage.inst().clear();
        }
    }

    private boolean check() {
        String id = Bee.getResreq().getCookie("_client");
        String clientId = Bee.getRequestParam().header.getClientId();
        String random = Bee.getResreq().getCookie("_random");
        String tmpId = MD5.encode((String)(String.valueOf(clientId) + random));
        return !Format.noEmpty((Object)id) || !Format.noEmpty((Object)random) || id.equals(tmpId);
    }
}

