/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.core.db.RequestParam;
import bee.cloud.engine.config.HttpMethods;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QTable;
import bee.cloud.engine.config.sqlmap.RParent;
import bee.cloud.engine.config.sqlmap.Relation;
import bee.cloud.service.core.HttpParam;
import bee.cloud.service.core.PathData;
import bee.cloud.service.core.result.Results;
import bee.tool.Tool;
import bee.tool.img.VerifyCode;
import bee.tool.string.Format;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(value={"/uris"})
public class UrisController {
    @GetMapping(produces={"application/json"})
    public Results getApi(HttpServletResponse response, HttpServletRequest request) {
        Results results = new Results();
        boolean c = Format.strToBoolean((String)request.getParameter("c"), (boolean)false);
        List apis = HttpMethods.getApis((boolean)c);
        results.succeed((Object)apis);
        return results;
    }

    @GetMapping(value={"apis"}, produces={"application/json"})
    public Results getApis(HttpServletResponse response, HttpServletRequest request) {
        Results results = new Results();
        List tmps = HttpMethods.getApis();
        ArrayList apis = new ArrayList();
        tmps.forEach(obj -> {
            String[] method;
            Map map = (Map)obj;
            String[] stringArray = method = map.get("method").toString().split(",");
            int n = method.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                item.putAll(map);
                switch (m) {
                    case "gets": {
                        item.put("method", "get");
                        item.put("uri", map.get("uri") + "'s");
                        break;
                    }
                    case "get": {
                        item.put("method", "get");
                        break;
                    }
                    case "post": {
                        item.put("method", "post");
                        break;
                    }
                    case "put": {
                        item.put("method", "put");
                        break;
                    }
                    case "delete": {
                        item.put("method", "delete");
                    }
                }
                apis.add(item);
                ++n2;
            }
        });
        Collections.sort(apis, (a, b) -> {
            String urib;
            Map ma = (Map)a;
            Map mb = (Map)b;
            String uria = ma.get("uri").toString();
            if (uria.equals(urib = mb.get("uri").toString())) {
                return 0;
            }
            return uria.compareTo(urib);
        });
        results.succeed(apis);
        return results;
    }

    @GetMapping(value={"/{item1}", "/{item1}/{item2}", "/{item1}/{item2}/{item3}", "/{item1}/{item2}/{item3}/{item4}", "/{item1}/{item2}/{item3}/{item4}/{item5}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}"}, produces={"application/json"})
    public Results getApiInfo(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        Map mapInfo = api.toMapInfo();
        String method = request.getParameter("method");
        if (Format.noEmpty((Object)method)) {
            mapInfo.put("method", method);
        }
        results.succeed((Object)mapInfo);
        return results;
    }

    @PutMapping(value={"/{item1}", "/{item1}/{item2}", "/{item1}/{item2}/{item3}", "/{item1}/{item2}/{item3}/{item4}", "/{item1}/{item2}/{item3}/{item4}/{item5}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}"}, produces={"application/json"})
    public Results updateUriInfo(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        if (api.getObject() instanceof QTable) {
            RequestParam rparam = httpParam.getRParam();
            rparam.put("uri", pdata.getUri());
            rparam.put("type", "uri");
            api.update(rparam);
            results.succeed((Object)"ok");
        } else {
            results.error((Object)"\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
        }
        return results;
    }

    @PutMapping(value={"/{item1}/param", "/{item1}/{item2}/param", "/{item1}/{item2}/{item3}/param", "/{item1}/{item2}/{item3}/{item4}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}/param"}, produces={"application/json"})
    public Results updateUriParam(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        if (api.getObject() instanceof QTable) {
            RequestParam rparam = httpParam.getRParam();
            rparam.put("uri", pdata.getUri());
            rparam.put("type", "param");
            api.update(rparam);
            results.succeed((Object)"ok");
        } else {
            results.error((Object)"\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
        }
        return results;
    }

    @PutMapping(value={"/{item1}/relation", "/{item1}/{item2}/relation", "/{item1}/{item2}/{item3}/relation", "/{item1}/{item2}/{item3}/{item4}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}/relation"}, produces={"application/json"})
    public Results updateUriRelation(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        if (api.getObject() instanceof QTable) {
            QTable qt = (QTable)api.getObject();
            RequestParam rparam = httpParam.getRParam();
            rparam.put("uri", pdata.getUri());
            rparam.put("type", "relation");
            String fk = httpParam.getParam("fk");
            String ruri = httpParam.getParam("ruri");
            String alias = httpParam.getParam("alias");
            int state = rparam.asInt("state");
            if (state == 1) {
                qt.getRelations().remove(alias);
            } else {
                QApi.HApi rapi = QApi.getApi((String)ruri);
                if (rapi == null) {
                    results.error((Object)("\u3010" + ruri + "\u3011\u4e0d\u5b58\u5728!"));
                } else {
                    RParent parent = new RParent(fk, (QTable)rapi.getObject(), alias);
                    qt.addRelation((Relation)parent);
                    results.succeed((Object)"ok");
                }
            }
            api.update(httpParam.getRParam());
        } else {
            results.error((Object)"\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
        }
        return results;
    }

    @GetMapping(value={"/code"})
    public void verifyCode(HttpServletResponse response, HttpServletRequest request) throws IOException {
        Results results = new Results();
        results.setResponse(response);
        VerifyCode.Img img = Tool.VerifyCode.getImgCode();
        results.setContentType("image/gif;charset=UTF-8");
        Cookie cookie = new Cookie("code", img.verifyCode);
        cookie.setDomain("web.bee.com");
        cookie.setPath("/");
        cookie.setMaxAge(3600);
        response.addCookie(cookie);
        results.build(img.getBytes());
    }
}

