/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.work;

import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.tool.Tool;
import bee.tool.string.Format;
import bee.tool.string.MD5;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Respond
implements Bee.Resreq {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private Map<String, String> cookies;

    public Respond(HttpServletResponse response, HttpServletRequest request) {
        this.response = response;
        this.request = request;
    }

    public ServletRequest getServletRequest() {
        return this.request;
    }

    public RequestParam getRequestParam() {
        return Bee.getRequestParam();
    }

    public String getCookie(String name) {
        if (this.cookies != null && this.cookies.containsKey(name)) {
            return this.cookies.get(name);
        }
        Cookie[] tcookies = this.request.getCookies();
        if (tcookies != null) {
            Cookie[] cookieArray = tcookies;
            int n = tcookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (name.equals(cookie.getName())) {
                    if (this.cookies == null) {
                        this.cookies = new HashMap<String, String>();
                    }
                    this.cookies.put(name, cookie.getValue());
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public void setHeader(String key, String value) {
        this.response.addHeader(key, value);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public ServletResponse getServletResponse() {
        return this.response;
    }

    public void setCookie(Bee.Cookie bcookie) {
        this.response.addHeader("Set-Cookie", bcookie.toString());
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(bcookie.getName(), bcookie.getValue());
    }

    public String getClientId() {
        return MD5.encode((String)(String.valueOf(this.getIpAddr()) + this.getAgent()));
    }

    private String getIpAddr() {
        String ip = this.request.getHeader("x-forwarded-for");
        if (Format.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = this.request.getHeader("Proxy-Client-IP");
        }
        if (Format.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = this.request.getHeader("WL-Proxy-Client-IP");
        }
        if (Format.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = this.request.getHeader("X-Real-IP");
        }
        if (Format.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = this.request.getRemoteAddr();
        }
        return ip;
    }

    private String getAgent() {
        String agent = Tool.Value.toSingle((String[])new String[]{this.request.getHeader("User-Agent"), this.request.getHeader("user-agent")});
        return agent;
    }
}

