/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.error;

import bee.cloud.config.BSystem;
import bee.cloud.core.db.RequestParam;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.err.ErrMonitor;
import bee.tool.log.Log;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExcHandler
extends ErrMonitor {
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, Object> errorHandler(Exception e) {
        this.monitor();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (e instanceof BeeException) {
            int code;
            BeeException be = (BeeException)((Object)e);
            if (be.getOther() != null && be.getOther() instanceof RequestParam) {
                RequestParam param = (RequestParam)be.getOther();
                Tool.Log.error((String)"=============\u9519\u8bef\u4fe1\u606f\u6570\u636e\u96c6===============");
                Tool.Log.error((String)"URI:/{}", (Object[])new Object[]{param.getUri()});
                Tool.Log.error((String)"\u53c2\u6570:{}", (Object[])new Object[]{param.toString()});
                Tool.Log.error((String)"\u8bf7\u6c42\u5934:{}", (Object[])new Object[]{Tool.Json.objToJsonString((Object)param.header)});
                Tool.Log.error((String)"\u8bf7\u6c42Cookie:{}", (Object[])new Object[]{Tool.Json.objToJsonString((Object)param.cookie)});
            }
            map.put("code", (code = be.getCode()) > 0 ? Integer.valueOf(code) : be.getState());
            map.put("message", e.getMessage());
            map.put("status", be.getStatus() > 0 ? be.getStatus() : (code < 1000 ? code : 300));
            Log.error((String)e.getMessage());
            Log.error((Throwable)e);
        } else {
            map.put("code", 0);
            map.put("message", e.getMessage());
            map.put("status", 300);
            Tool.Log.error((Throwable)e);
        }
        if (!"prod".equals(BSystem.get((String)"spring.profiles.active"))) {
            map.put("error", this.getErrorInfo(e));
        }
        return map;
    }

    public String getErrorInfo(Exception e) {
        StackTraceElement[] stackTrace;
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = stackTrace = e.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            String clsName = ste.getClassName();
            if (clsName.startsWith("bee.")) {
                String[] arr = ste.getClassName().split("\\.");
                String pkg = "";
                int i = 0;
                while (i < arr.length) {
                    String a = arr[i];
                    pkg = String.valueOf(pkg) + "." + (i + 1 < arr.length ? a.substring(0, 1) : a.replaceAll("[^A-Z$]", ""));
                    ++i;
                }
                clsName = pkg.substring(1);
            }
            sb.append(clsName).append(".").append(ste.getMethodName()).append("():").append(ste.getLineNumber()).append("<br>");
            ++n2;
        }
        return sb.toString();
    }
}

