/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.config.tool.Dict;
import bee.cloud.service.core.result.Results;
import bee.tool.RuntimeTool;
import bee.tool.Tool;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class SystemController {
    @GetMapping(value={"/dict"}, produces={"application/json"})
    public Results getDict(HttpServletResponse response, HttpServletRequest request) {
        Results results = new Results();
        String codes = request.getParameter("code");
        if (Tool.Format.isEmpty((String)codes)) {
            results.succeed((Object)Dict.toMaps());
        } else {
            HashMap<String, Map> map = new HashMap<String, Map>();
            String[] stringArray = codes.split(",|\uff0c");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                Dict dict = Dict.get((String)code.trim());
                map.put(code.trim(), dict != null ? dict.toMap() : null);
                ++n2;
            }
            results.succeed(map);
        }
        return results;
    }

    @GetMapping(value={"/dict/{code}"}, produces={"application/json"})
    public Results getDict(@PathVariable(value="code") String code) {
        Results results = new Results();
        Dict dict = Dict.get((String)code.trim());
        results.succeed((Object)(dict != null ? dict.toMap() : null));
        return results;
    }

    @GetMapping(value={"/info"}, produces={"application/json"})
    public Object getSystem() {
        return RuntimeTool.getInfos();
    }
}

