/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.feign.work;

import bee.cloud.core.db.RequestParam;
import bee.cloud.core.db.RmiData;
import bee.cloud.engine.db.core.CBase;
import bee.cloud.engine.util.Result;
import bee.cloud.ri.Rmi;
import bee.cloud.service.feign.ApiClient;
import bee.cloud.service.feign.RmiClient;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RmiWork
implements Rmi {
    @Autowired
    private RmiClient rmiClient;

    public Result call(RequestParam param) {
        if (param == null) {
            throw new BeeException("\u53c2\u6570\u3010param\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String uri = param.getUri();
        if (Tool.Format.isEmpty((String)uri)) {
            throw new BeeException("\u53d6\u6570\u636e\u8def\u5f84\u3010uri\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] tmp = uri.trim().split("/");
        String serverName = Tool.Format.isEmpty((String)tmp[0]) ? tmp[1] : tmp[0];
        uri = uri.substring(uri.indexOf(serverName) + serverName.length() + 1);
        param.setUri(uri);
        ApiClient client = this.rmiClient.getFeignClient(serverName, uri);
        String method = param.getMethod();
        Result result = "get".equalsIgnoreCase(method) ? client.get(param.toRmiData().getData()) : ("post".equalsIgnoreCase(method) ? client.post(param.toRmiData().getData()) : ("put".equalsIgnoreCase(method) ? client.put(param.toRmiData().getData()) : ("delete".equalsIgnoreCase(method) ? client.delete(param.toRmiData().getData()) : client.get(param.toRmiData().getData()))));
        return result;
    }

    public Result get(RequestParam param) {
        param.header.put("method", "get");
        return this.call(param);
    }

    public Result post(RequestParam param) {
        param.header.put("method", "post");
        return this.call(param);
    }

    public Result put(RequestParam param) {
        param.header.put("method", "put");
        return this.call(param);
    }

    public Result delete(RequestParam param) {
        param.header.put("method", "delete");
        return this.call(param);
    }

    public Result call(String uri, RequestParam param) {
        if (param != null) {
            param.setUri(uri);
        }
        return this.call(param);
    }

    public Result get(String uri, RequestParam param) {
        param.header.put("method", "get");
        return this.call(uri, param);
    }

    public Result post(String uri, RequestParam param) {
        param.header.put("method", "post");
        return this.call(uri, param);
    }

    public Result put(String uri, RequestParam param) {
        param.header.put("method", "put");
        return this.call(uri, param);
    }

    public Result delete(String uri, RequestParam param) {
        param.header.put("method", "delete");
        return this.call(uri, param);
    }

    public <T extends CBase> T getTable(Class<T> clazz, String uri, RequestParam param) {
        Result result = this.call(uri, param);
        return (T)((CBase)result.getTable(clazz));
    }

    public <T extends CBase> List<T> getTables(Class<T> clazz, String uri, RequestParam param) {
        Result result = this.call(uri, param);
        return result.getTables(clazz);
    }

    public Result upload(String serverName, Rmi.RmiFile rfile, RmiData rmiData) {
        ApiClient client = this.rmiClient.getUploadFeignClient(serverName, "/upload/one");
        try {
            MockMultipartFile file = new MockMultipartFile("file", rfile.getName(), null, rfile.getInputStream());
            MockMultipartFile cover = null;
            InputStream coverInputStream = rfile.getCoverInputStream();
            if (coverInputStream != null) {
                cover = new MockMultipartFile("cover", "cover" + rfile.getName(), null, coverInputStream);
            }
            Result result = client.upload((MultipartFile)file, (MultipartFile)cover, rmiData);
            return result;
        }
        catch (IOException e) {
            Tool.Log.error((Throwable)e);
            return null;
        }
    }
}

