/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.feign.controller;

import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.engine.util.Result;
import bee.cloud.ri.Rmi;
import bee.cloud.service.core.ShowApi;
import bee.cloud.service.core.annotation.API;
import bee.cloud.service.core.annotation.ApiParam;
import bee.cloud.service.core.result.Results;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ControllerAdvice
@RequestMapping(value={"/feign"})
public class TestFeign
extends ShowApi {
    @Autowired
    private Rmi rmi;

    public boolean isShow() {
        return false;
    }

    @API(title="Feign\u6d4b\u8bd5", param={@ApiParam(name="uri", title="\u6570\u636eURI", memo="\u5e94\u7528\u540d\u79f0+API\u63a5\u53e3\u5730\u5740"), @ApiParam(name="method", title="\u8bf7\u6c42\u65b9\u6cd5", memo="GET\u3001POST\u3001PUT\u3001DELETE")})
    @RequestMapping(value={"/test"})
    public @ApiParam(name="uri", title="\u6570\u636eURI", memo="\u5e94\u7528\u540d\u79f0+API\u63a5\u53e3\u5730\u5740") @ApiParam(name="method", title="\u8bf7\u6c42\u65b9\u6cd5", memo="GET\u3001POST\u3001PUT\u3001DELETE") Results test() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String uri = param.asText("uri");
        String method = param.asText("method");
        RequestParam rmiParam = param.cloneNew(new String[0]);
        rmiParam.setMethod(method).setUri(uri).putAll(param.getRoot());
        Result result = this.rmi.call(rmiParam);
        results.succeed((Object)result);
        return results;
    }

    @API(title="\u4e0a\u4f20\u6587\u4ef6", memo="\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\uff0c\u8fd4\u56de\u4e0a\u4f20\u6210\u529f\u7684\u6587\u4ef6\u8bbf\u95ee\u8def\u5f84", param={@ApiParam(name="server_name", title="\u5e94\u7528\u540d\u79f0"), @ApiParam(name="file", title="\u6587\u4ef6\uff0c\u4e0d\u80fd\u4e3a\u7a7a", type=QEnum.QType.FILE, length=-1, memo="\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\uff0c\u8fd4\u56de\u4e0a\u4f20\u6210\u529f\u7684\u6587\u4ef6\u8bbf\u95ee\u8def\u5f84"), @ApiParam(name="cover", title="\u5c01\u9762\uff0c\u5141\u8bb8\u4e3a\u7a7a", type=QEnum.QType.FILE, length=-1, memo="\u4e0a\u4f20\u6587\u4ef6\u7684\u5c01\u9762\uff0c\u5f53file\u4e3a\u56fe\u7247\u7c7b\u578b\u65f6\u4e0d\u9700\u8981\u4e0a\u4f20cover\u56fe\u7247\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u6839\u636efile\u56fe\u7247\u751f\u6210\u5bf9\u5e94\u7684\u7f29\u7565\u56fe\uff0c\u5982\u4e0a\u4f20cover\u65f6\uff0c\u7cfb\u7edfwf\u6839\u636e\u5bf9\u5e94\u53c2\u6570\u751f\u6210\u76f8\u5e94\u5927\u5c0f\u7f29\u7565\u56fe")})
    @PostMapping(value={"/upload"})
    @ResponseBody
    public @ApiParam(name="server_name", title="\u5e94\u7528\u540d\u79f0") @ApiParam(name="file", title="\u6587\u4ef6\uff0c\u4e0d\u80fd\u4e3a\u7a7a", type=QEnum.QType.FILE, length=-1, memo="\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\uff0c\u8fd4\u56de\u4e0a\u4f20\u6210\u529f\u7684\u6587\u4ef6\u8bbf\u95ee\u8def\u5f84") @ApiParam(name="cover", title="\u5c01\u9762\uff0c\u5141\u8bb8\u4e3a\u7a7a", type=QEnum.QType.FILE, length=-1, memo="\u4e0a\u4f20\u6587\u4ef6\u7684\u5c01\u9762\uff0c\u5f53file\u4e3a\u56fe\u7247\u7c7b\u578b\u65f6\u4e0d\u9700\u8981\u4e0a\u4f20cover\u56fe\u7247\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u6839\u636efile\u56fe\u7247\u751f\u6210\u5bf9\u5e94\u7684\u7f29\u7565\u56fe\uff0c\u5982\u4e0a\u4f20cover\u65f6\uff0c\u7cfb\u7edfwf\u6839\u636e\u5bf9\u5e94\u53c2\u6570\u751f\u6210\u76f8\u5e94\u5927\u5c0f\u7f29\u7565\u56fe") Result upload(@RequestPart(value="file") MultipartFile file, @Nullable @RequestPart(value="cover") MultipartFile cover) {
        try {
            Rmi.RmiFile rf = new Rmi.RmiFile();
            rf.setName(file.getOriginalFilename());
            rf.setInputStream(file.getInputStream());
            if (cover != null) {
                rf.setCoverInputStream(cover.getInputStream());
            }
            RequestParam param = Bee.getRequestParam();
            String serverName = param.asText("server_name");
            RequestParam rmiParam = param.cloneNew(new String[0]);
            rmiParam.put("test", "123456");
            Result result = this.rmi.upload(serverName, rf, rmiParam.toRmiData());
            return result;
        }
        catch (Exception e) {
            Tool.Log.error((Throwable)e);
            throw new BeeException((Throwable)e);
        }
    }
}

