/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.feign.config;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.ContentType;
import feign.form.MultipartFormContentProcessor;
import feign.form.multipart.Writer;
import feign.form.spring.SpringFormEncoder;
import feign.form.spring.SpringManyMultipartFilesWriter;
import feign.form.spring.SpringSingleMultipartFileWriter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class SpringMultipartEncoder
extends SpringFormEncoder {
    public SpringMultipartEncoder() {
        this((Encoder)new Encoder.Default());
    }

    public SpringMultipartEncoder(Encoder delegate) {
        super(delegate);
        MultipartFormContentProcessor processor = (MultipartFormContentProcessor)this.getContentProcessor(ContentType.MULTIPART);
        processor.addWriter((Writer)new SpringSingleMultipartFileWriter());
        processor.addWriter((Writer)new SpringManyMultipartFilesWriter());
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (bodyType != null && bodyType.equals(MultipartFile.class)) {
            MultipartFile file = (MultipartFile)object;
            if (file != null) {
                Map<String, Object> data = Collections.singletonMap(file.getName(), object);
                super.encode(data, MAP_STRING_WILDCARD, template);
                return;
            }
        } else if (bodyType != null && bodyType.equals(MultipartFile[].class)) {
            if (object != null) {
                MultipartFile[] files = (MultipartFile[])object;
                HashMap<String, MultipartFile> data = new HashMap<String, MultipartFile>();
                int i = 1;
                while (i <= files.length) {
                    data.put("file" + i, files[i - 1]);
                    ++i;
                }
                super.encode(data, MAP_STRING_WILDCARD, template);
                return;
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            boolean isMult = false;
            for (Object o : map.values()) {
                if (!(o instanceof MultipartFile)) continue;
                isMult = true;
                break;
            }
            if (isMult) {
                super.encode(object, MAP_STRING_WILDCARD, template);
                return;
            }
        }
        super.encode(object, bodyType, template);
    }
}

