/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.feign.config;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignClientConfig {
    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder multipartFormEncoder() {
        return new SpringFormEncoder();
    }

    @Bean(value={"requestInterceptor"})
    public static RequestInterceptor requestInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate template) {
                HttpServletRequest request;
                ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (requestAttributes != null && Objects.nonNull(request = requestAttributes.getRequest())) {
                    Enumeration headerNames = request.getHeaderNames();
                    while (headerNames.hasMoreElements()) {
                        String name = (String)headerNames.nextElement();
                        String value = request.getHeader(name);
                        template.header(name, new String[]{value});
                    }
                    template.header("x-forwarded-sign", new String[]{"bee-feign"});
                }
            }
        };
    }
}

