/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.feign;

import bee.cloud.service.feign.ApiClient;
import bee.cloud.service.feign.RmiClient;
import bee.cloud.service.feign.work.ApiClientFallback;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DynamicFeignClient
implements RmiClient {
    private static final Map<String, ApiClient> clients = new HashMap<String, ApiClient>();
    private FeignClientBuilder feignClientBuilder;
    private FeignContext context;

    public DynamicFeignClient(@Autowired ApplicationContext appContext, @Autowired FeignContext context) {
        this.feignClientBuilder = new FeignClientBuilder(appContext);
        this.context = context;
    }

    public ApiClient getFeignClient(String seviceName) {
        return this.getFeignClient(seviceName, "/remote/api");
    }

    @Override
    public ApiClient getFeignClient(String seviceName, String path) {
        String key;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (clients.containsKey(key = String.valueOf(seviceName) + path)) {
            return clients.get(key);
        }
        ApiClient client = (ApiClient)this.feignClientBuilder.forType(ApiClient.class, seviceName).path(path).fallback(ApiClientFallback.class).build();
        clients.put(key, client);
        return client;
    }

    @Override
    public ApiClient getUploadFeignClient(String seviceName, String path) {
        String key;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (clients.containsKey(key = String.valueOf(seviceName) + path)) {
            return clients.get(key);
        }
        ApiClient client = (ApiClient)this.feignClientBuilder.forType(ApiClient.class, seviceName).path(path).fallback(ApiClientFallback.class).build();
        clients.put(key, client);
        return client;
    }
}

