/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.parser.util;

import bee.cloud.parser.Expr;
import bee.cloud.parser.dom.A;
import bee.cloud.parser.dom.Div;
import bee.cloud.parser.dom.I;
import bee.cloud.parser.dom.Img;
import bee.cloud.parser.dom.Input;
import bee.cloud.parser.dom.Li;
import bee.cloud.parser.dom.Other;
import bee.cloud.parser.dom.P;
import bee.cloud.parser.dom.Span;
import bee.cloud.parser.dom.Tag;
import bee.cloud.parser.dom.Ul;
import bee.cloud.parser.util.TableUtil;
import bee.tool.file.FileOperate;
import bee.tool.log.Log;
import bee.tool.string.Format;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.lexer.PageAttribute;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;

public class Util {
    private static final Logger logger = Log.getLogger(Util.class);

    private Util() {
    }

    public static void setAttr(Tag tag, String name, String value) {
        if (Format.isEmpty((String)name)) {
            return;
        }
        if ("class".equalsIgnoreCase(name)) {
            name = "clazz";
        }
        String method = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            Class<?> cls = tag.getClass();
            Method setMethod = cls.getMethod(method, String.class);
            setMethod.invoke((Object)tag, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String clearHtml(String html) {
        if (Format.isEmpty((String)html)) {
            return html;
        }
        Pattern p = Pattern.compile("(<[^>]*>)", 2);
        Matcher m = p.matcher(html);
        return Util.clearEnter(m.replaceAll(""));
    }

    public static String clearIframe(String html) {
        if (Format.isEmpty((String)html)) {
            return html;
        }
        Pattern p = Pattern.compile("(<(iframe)[^>]*>)|(</iframe>)", 2);
        Matcher m = p.matcher(html);
        return Util.clearEnter(m.replaceAll(""));
    }

    public static String clearIframeA(String html) {
        if (Format.isEmpty((String)html)) {
            return html;
        }
        Pattern p = Pattern.compile("(href=['|\"]*['|\"]\\s?)|(<(iframe)[^>]*>)|(</iframe>)", 2);
        Matcher m = p.matcher(html);
        return Util.clearEnter(m.replaceAll(""));
    }

    public static String clearEnter(String str) {
        if (Format.isEmpty((String)str)) {
            return str;
        }
        Pattern p = Pattern.compile("\t|\r|\n|\f|(<(a)[^>]*>)|(</a>)|(<(iframe)[^>]*>)|(</iframe>)|(<(script)(.*)/>)|(<script(.*)>(.*)</script>)|(<!--(.*)-->)|(/\\*(.*)\\*/)|( on\\w+[\\s+]?=[\"'\\s+]\\(.*\\)[\"'\\s+])", 2);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static String clearWord(String content) {
        Pattern p = Pattern.compile("</?SPAN[^>]*>", 2);
        Matcher match = p.matcher(content);
        content = match.replaceAll("");
        p = Pattern.compile("(<P)([^>]*>.*?)(<\\/P>)", 2);
        match = p.matcher(content);
        content = match.replaceAll("<div$2</div>");
        p = Pattern.compile("<(\\w[^>]*) class=([^ |>]*)([^>]*)", 2);
        match = p.matcher(content);
        content = match.replaceAll("<$1$3");
        p = Pattern.compile("<(\\w[^>]*) style=\"([^\"]*)\"([^>]*)", 2);
        match = p.matcher(content);
        content = match.replaceAll("<$1$3");
        p = Pattern.compile("<(\\w[^>]*) lang=([^ |>]*)([^>]*)", 2);
        match = p.matcher(content);
        content = match.replaceAll("<$1$3");
        p = Pattern.compile("<\\\\?\\?xml[^>]*>", 2);
        match = p.matcher(content);
        content = match.replaceAll("");
        p = Pattern.compile("<\\/?\\w+:[^>]*>", 2);
        match = p.matcher(content);
        content = match.replaceAll("");
        p = Pattern.compile("/ /");
        match = p.matcher(content);
        content = match.replaceAll(" ");
        return content;
    }

    public static String clear(String content) {
        content = Util.clearIframeA(content);
        content = Util.clearWord(content);
        return content;
    }

    public static ArrayList<String> match(String expression) {
        if (Format.isEmpty((String)expression)) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        String chunker = "((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^\\[\\]]*\\]|['\"][^'\"]*['\"]|[^\\[\\]'\"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)";
        Pattern pattern = Pattern.compile(chunker);
        String soFar = expression;
        Matcher matcher = pattern.matcher(soFar);
        while (matcher.find()) {
            String a = matcher.group(1);
            parts.add(a);
            String o = matcher.group();
            soFar = o.substring(a.length()).trim();
            matcher = pattern.matcher(soFar);
        }
        pattern = null;
        matcher = null;
        return parts;
    }

    public static NodeList filter(NodeList parent, ArrayList<String> parts) {
        NodeList list = parent;
        boolean recursive = true;
        for (String part : parts) {
            if (">".equals(part)) {
                recursive = false;
                NodeList tmp = new NodeList();
                int i = 0;
                int l = list.size();
                while (i < l) {
                    Node node = list.elementAt(i);
                    NodeList children = node.getChildren();
                    if (children != null) {
                        tmp.add(children);
                    }
                    ++i;
                }
                Util.clear(list);
                list = tmp;
                continue;
            }
            part = part.startsWith("table") ? part : TableUtil.toExpression(part);
            list = Util.queryChildren(list, part, recursive);
            recursive = true;
            if (!part.startsWith("table")) continue;
            String html = list.toHtml();
            html = html.replaceAll("<table", "<div ").replaceAll("/table>", "/div>");
            html = html.replaceAll("<thead", "<h1").replaceAll("/thead>", "/h1>");
            html = html.replaceAll("<th", "<span").replaceAll("/th>", "/span>");
            html = html.replaceAll("<tbody", "<div").replaceAll("/tbody>", "/div>");
            html = html.replaceAll("<tr", "<div").replaceAll("/tr>", "/div>");
            html = html.replaceAll("<td", "<span").replaceAll("/td>", "/span>");
            list = Util.toNodeList(html, TableUtil.toExpression(part));
        }
        return list;
    }

    public static NodeList toNodeList(String html, String expression) {
        Parser parser = Parser.createParser((String)html, (String)"GBK");
        try {
            NodeFilter filter = Util.toNodeFilter(expression);
            NodeList nl = parser.extractAllNodesThatMatch(filter);
            return nl;
        }
        catch (ParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NodeList queryChildren(NodeList list, String expression, boolean recursive) {
        NodeFilter filter = Util.toNodeFilter(expression);
        int pos = expression.matches(".*:\\d+") ? Format.strToInt((String)expression.substring(expression.lastIndexOf(":") + 1)) : -1;
        NodeList nl = new NodeList();
        NodeList li = list.extractAllNodesThatMatch(filter, recursive);
        if (pos >= 0) {
            nl.add(li.elementAt(pos));
        } else {
            nl.add(li);
        }
        Util.clear(li);
        return nl;
    }

    public static NodeFilter toNodeFilter(String expression) {
        String tagName = Util.getTagName(expression);
        String tagAttr = Util.getTagAttr(expression);
        String[] attr = Format.strToStrArr((String)tagAttr, (String)"=");
        if ("table".equalsIgnoreCase(tagName)) {
            AndFilter filter = !Format.isEmpty((String)tagAttr) ? new AndFilter((NodeFilter)new NodeClassFilter(TableTag.class), (NodeFilter)new HasAttributeFilter(attr[0], attr.length > 1 ? attr[1] : "")) : new NodeClassFilter(TableTag.class);
            return filter;
        }
        AndFilter filter = !Format.isEmpty((String)tagName) && !Format.isEmpty((String)tagAttr) ? new AndFilter((NodeFilter)new TagNameFilter(tagName), (NodeFilter)new HasAttributeFilter(attr[0], attr.length > 1 ? attr[1] : "")) : (!Format.isEmpty((String)tagName) ? new TagNameFilter(tagName) : null);
        return filter;
    }

    public static String getTagName(String expression) {
        String exp = Expr.leftMatch("TAG");
        Pattern pattern = Pattern.compile(exp);
        Matcher matcher = pattern.matcher(expression);
        String tag = matcher.find() ? matcher.group(0) : null;
        matcher = null;
        pattern = null;
        return tag;
    }

    public static String getTagAttr(String expression) {
        String exp = Expr.leftMatch("ATTR");
        String attr = null;
        if (expression.matches(exp)) {
            attr = expression.substring(expression.indexOf("[") + 1, expression.indexOf("]"));
        }
        return attr;
    }

    public static <T extends Tag> List<T> toTag(NodeList list, String encoding) {
        ArrayList<T> tags = new ArrayList<T>();
        int j = 0;
        int k = list.size();
        while (j < k) {
            T tag = Util.toTag(list.elementAt(j), encoding);
            tags.add(tag);
            ++j;
        }
        return tags;
    }

    private static <T extends Tag> T toTag(Node node, String encoding) {
        TagNode tn = (TagNode)node;
        T tag = Util.toTag(node);
        ((Tag)tag).setEncoding(encoding);
        Vector v = tn.getAttributesEx();
        for (PageAttribute p : v) {
            String name = p.getName();
            if (Format.isEmpty((String)name) || name.equalsIgnoreCase(((Tag)tag).getTagName())) continue;
            Util.setAttr(tag, name, p.getValue());
        }
        return tag;
    }

    private static <T extends Tag> T toTag(Node node) {
        TagNode tn = (TagNode)node;
        Vector vector = tn.getAttributesEx();
        PageAttribute pa = (PageAttribute)vector.get(0);
        String tagName = pa.getName();
        A tag = "A".equalsIgnoreCase(tagName) ? new A() : ("DIV".equalsIgnoreCase(tagName) ? new Div() : ("IMG".equalsIgnoreCase(tagName) ? new Img() : ("UL".equalsIgnoreCase(tagName) ? new Ul() : ("LI".equalsIgnoreCase(tagName) ? new Li() : ("SPAN".equalsIgnoreCase(tagName) ? new Span() : ("INPUT".equalsIgnoreCase(tagName) ? new Input() : ("P".equalsIgnoreCase(tagName) ? new P() : ("I".equalsIgnoreCase(tagName) ? new I() : new Other()))))))));
        tag.setTagName(tagName);
        tag.setNode(node);
        return (T)tag;
    }

    public static void clear(NodeList nodes) {
        if (nodes == null) {
            return;
        }
        nodes.removeAll();
        nodes = null;
    }

    public static String objectToJson(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(object);
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveData(Object data, String filepath) {
        try {
            if (data instanceof String) {
                FileOperate.write((String)filepath, (String)data.toString());
            } else {
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString(data);
                FileOperate.write((String)filepath, (String)json);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

