/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.parser.util;

import bee.cloud.parser.util.Util;
import bee.tool.string.Format;

public class TableUtil {
    public static String toExpression(String expression) {
        String tagName = Util.getTagName(expression);
        if (Format.isEmpty((String)tagName)) {
            return expression;
        }
        Tag tag = Tag.nameOf(tagName);
        if (tag == null) {
            return expression;
        }
        return expression.replaceFirst(tagName, tag.toString());
    }

    static enum Tag {
        TABLE{

            public String toString() {
                return "div";
            }
        }
        ,
        THEAD{

            public String toString() {
                return "h1";
            }
        }
        ,
        TH{

            public String toString() {
                return "span";
            }
        }
        ,
        TBODY{

            public String toString() {
                return "div";
            }
        }
        ,
        TR{

            public String toString() {
                return "div";
            }
        }
        ,
        TD{

            public String toString() {
                return "span";
            }
        };


        public static Tag nameOf(String name) {
            switch (name.toUpperCase()) {
                case "TABLE": {
                    return TABLE;
                }
                case "THEAD": {
                    return THEAD;
                }
                case "TH": {
                    return TH;
                }
                case "TBODY": {
                    return TBODY;
                }
                case "TR": {
                    return TR;
                }
                case "TD": {
                    return TD;
                }
            }
            return null;
        }
    }
}

