/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.parser.dom;

import bee.cloud.parser.util.Util;
import bee.tool.string.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeList;

public abstract class Tag {
    private String tagName;
    private String Id;
    private String name;
    private String title;
    private String clazz;
    private Node node;
    private String html = null;
    private String text = null;
    private String encoding;
    protected Referer referer = null;

    public String getId() {
        return this.Id;
    }

    public void setId(String id) {
        this.Id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
        Referer referer = new Referer();
        if (referer.href != null) {
            this.referer = referer;
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getAttribute(String name) {
        TagNode tn = (TagNode)this.node;
        return tn.getAttribute(name);
    }

    public void setAttribute(String name, String value) {
        TagNode tn = (TagNode)this.node;
        tn.setAttribute(name, value);
    }

    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public <T extends Tag> List<T> query(String expression) {
        String[] expressions;
        if (Format.isEmpty((String)expression)) {
            return null;
        }
        NodeList nodes = new NodeList();
        String[] stringArray = expressions = expression.split(",");
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            String exp = stringArray[n2];
            expression = exp;
            ArrayList<String> parts = Util.match(expression);
            if (parts.size() != 0) {
                NodeList list = Util.filter(new NodeList(this.node), parts);
                if (list.size() > 0) {
                    nodes.add(list);
                }
                Util.clear(list);
            }
            ++n2;
        }
        List tags = Util.toTag(nodes, null);
        Util.clear(nodes);
        return tags;
    }

    public String toHtml() {
        this.toHtml(null);
        return this.html;
    }

    public String toHtml(String notExpression) {
        String tmpHtml;
        NodeList children = this.node.getChildren();
        String string = tmpHtml = children != null ? children.toHtml() : this.node.toHtml();
        if (!Format.isEmpty((String)notExpression) && children != null) {
            String noHtml = Util.queryChildren(children, notExpression, true).toHtml();
            tmpHtml = tmpHtml.replace(noHtml, "");
        }
        Util.clear(children);
        this.html = Util.clear(tmpHtml);
        return this.html;
    }

    public String toText() {
        this.toText(null);
        return this.text;
    }

    public String attrValue(String attrname, String expr) {
        if (Format.isEmptys((String[])new String[]{attrname})) {
            return null;
        }
        String value = this.getAttribute(attrname);
        if (Format.isEmpty((String)value)) {
            return null;
        }
        if (Format.noEmpty((Object)expr)) {
            Pattern pattern = Pattern.compile(expr);
            Matcher matcher = pattern.matcher(value);
            value = matcher.find() ? (matcher.groupCount() > 0 ? matcher.group(1) : matcher.group(0)) : null;
            matcher = null;
            pattern = null;
        }
        return value;
    }

    public String attrValue(String attrname) {
        return this.attrValue(attrname, null);
    }

    public String toText(String notExpression) {
        this.text = Util.clearHtml(this.toHtml(notExpression));
        return this.text;
    }

    protected class Referer {
        private String href = null;
        private String protocol = null;
        private String host = null;
        private String uri = null;
        private boolean isInit = false;

        public Referer() {
            this.init();
        }

        private void init() {
            if (this.isInit) {
                return;
            }
            this.href = Tag.this.node.getPage().getUrl();
            if (this.href == null) {
                return;
            }
            String[] tmp = this.href.split("://");
            this.protocol = tmp[0];
            this.host = tmp[1].indexOf("/") > 0 ? tmp[1].substring(0, tmp[1].indexOf("/")) : tmp[1];
            this.uri = tmp[1].substring(this.host.length());
            this.isInit = true;
        }

        public String getHref() {
            return this.href;
        }

        public String getHost() {
            return this.host;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getUri() {
            return this.uri;
        }

        public String getBaseUrl() {
            return String.valueOf(this.getProtocol()) + "://" + this.getHost();
        }

        public String getPath() {
            return this.href.substring(0, this.href.lastIndexOf("/"));
        }
    }
}

