/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.parser.dom;

import bee.cloud.parser.Parser;
import bee.cloud.parser.dom.Img;
import bee.cloud.parser.dom.Tag;
import bee.cloud.parser.util.Util;
import bee.tool.Tool;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.util.NodeList;

public final class A
extends Tag {
    private String href;
    private String target;
    private String content;
    private String expression;
    private boolean isCheckHref = false;

    private void checkHref() {
        if (this.isCheckHref) {
            return;
        }
        if (this.referer == null) {
            this.isCheckHref = true;
            return;
        }
        if (this.href == null || "".equals(this.href)) {
            this.href = this.referer.getHref();
        } else if ("/".equals(this.href.substring(0, 1))) {
            this.href = String.valueOf(this.referer.getBaseUrl()) + this.href;
        } else if ("../".equals(this.href.substring(0, 3))) {
            String uri = this.referer.getUri();
            uri = uri.substring(0, uri.lastIndexOf("/"));
            while ("../".equals(this.href.substring(0, 3))) {
                this.href = this.href.substring(3);
                uri = uri.substring(0, uri.lastIndexOf("/"));
            }
            this.href = String.valueOf(uri) + "/" + this.href;
        } else if ("./".equals(this.href.substring(0, 2))) {
            this.href = String.valueOf(this.referer.getPath()) + this.href.substring(1);
        }
        this.isCheckHref = true;
    }

    public String getHref() {
        this.checkHref();
        return this.href;
    }

    public A setHref(String href) {
        this.href = href;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public A setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public String toText() {
        if (!Tool.Format.isEmpty((String)this.getTitle())) {
            return this.getTitle();
        }
        return super.toText();
    }

    @Override
    public String attrValue(String attrname, String expr) {
        if (Tool.Format.isEmptys((String[])new String[]{attrname})) {
            return null;
        }
        String value = this.getAttribute(attrname);
        if (Tool.Format.isEmpty((String)value)) {
            return null;
        }
        if (Tool.Format.noEmpty((Object)expr)) {
            Pattern pattern = Pattern.compile(expr);
            Matcher matcher = pattern.matcher(value);
            value = matcher.find() ? (matcher.groupCount() > 0 ? matcher.group(1) : matcher.group(0)) : null;
            matcher = null;
            pattern = null;
        }
        return value;
    }

    @Override
    public String attrValue(String attrname) {
        return this.attrValue(attrname, null);
    }

    public String getContentText(String expression) {
        return this.getContentText(expression, null);
    }

    public String getContentText(String expression, String notExpression) {
        String html = this.getContentHtml(expression, notExpression);
        String text = Util.clearHtml(html);
        return text;
    }

    public String getContentHtml(String expression) {
        return this.getContentHtml(expression, null);
    }

    public String getContentHtml(String expression, String notExpression) {
        this.checkHref();
        if (!Tool.Format.isEmpty((String)expression) && !expression.equals(this.expression)) {
            this.expression = expression;
            this.content = null;
        }
        if (Tool.Format.isEmpty((String)expression)) {
            return this.content;
        }
        if (Tool.Format.isEmpty((String)this.content)) {
            Parser parser = new Parser(this.href, this.getEncoding());
            Object tag = parser.query(expression);
            this.content = tag != null ? ((Tag)tag).toHtml(notExpression) : null;
        }
        return this.content;
    }

    public List<Img> getImgs() {
        Node node = this.getNode();
        NodeList children = null;
        if (node != null) {
            this.getNode().getChildren();
        } else {
            Parser parser = new Parser(this.href, this.getEncoding());
            children = parser.parser(this.expression);
        }
        if (children == null) {
            return null;
        }
        NodeList imgs = children.extractAllNodesThatMatch(Util.toNodeFilter("img"), true);
        List<Img> list = Util.toTag(imgs, this.getEncoding());
        return list;
    }
}

