/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.parser;

import bee.cloud.parser.dom.Tag;
import bee.cloud.parser.util.Util;
import bee.tool.string.Format;
import java.util.ArrayList;
import java.util.List;
import org.htmlparser.NodeFilter;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;

public class Parser {
    private String url;
    private String encoding;
    private boolean isCache = false;
    private org.htmlparser.Parser parser;

    public Parser() {
        this(null);
    }

    public Parser(String url) {
        this(url, null);
    }

    public Parser(String url, String encoding) {
        this.url = url;
        this.encoding = encoding;
        this.init();
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setCache(boolean isCache) {
        this.isCache = isCache;
    }

    private void init() {
        try {
            this.parser = new org.htmlparser.Parser();
            this.parser.setURL(this.url);
            if (Format.isEmpty((String)this.encoding)) {
                this.encoding = "GB2312";
            }
            this.parser.setEncoding(this.encoding);
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public void setHTML(String html) {
        try {
            html = html.replaceAll("<!--.*-->", "");
            this.parser.setInputHTML(html);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    public <T extends Tag> T query(String expression) {
        List<T> tags = this.excute(expression);
        if (tags != null && tags.size() > 0) {
            Tag tag = (Tag)tags.remove(0);
            int i = tags.size();
            while (i > 0) {
                tags.remove(0);
                --i;
            }
            return (T)tag;
        }
        return null;
    }

    public <T extends Tag> List<T> excute(String expression) {
        ArrayList tmp = new ArrayList();
        if (Format.isEmpty((String)expression)) {
            return tmp;
        }
        NodeList nodes = this.parser(expression);
        List tags = Util.toTag(nodes, this.encoding);
        Util.clear(nodes);
        return tags;
    }

    public String getHtml(String expression) {
        if (Format.isEmpty((String)expression)) {
            return "";
        }
        NodeList nodes = this.parser(expression);
        if (nodes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SimpleNodeIterator it = nodes.elements();
        while (it.hasMoreNodes()) {
            sb.append(it.nextNode().getChildren().toHtml());
        }
        Util.clear(nodes);
        return sb.toString();
    }

    public String getText(String expression) {
        if (Format.isEmpty((String)expression)) {
            return "";
        }
        NodeList nodes = this.parser(expression);
        String html = nodes.toHtml();
        html = Util.clearHtml(html);
        Util.clear(nodes);
        return html;
    }

    public NodeList parser(String expression) {
        String[] expressions;
        NodeList nodes = new NodeList();
        if (Format.isEmpty((String)expression)) {
            return nodes;
        }
        NodeList body = this.queryBody();
        String[] stringArray = expressions = expression.split(",");
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            String exp = stringArray[n2];
            expression = exp;
            ArrayList<String> parts = Util.match(expression);
            if (parts.size() != 0) {
                NodeList list = Util.filter(body, parts);
                nodes.add(list);
                Util.clear(list);
            }
            ++n2;
        }
        Util.clear(body);
        return nodes;
    }

    private NodeList queryBody() {
        NodeFilter filter = Util.toNodeFilter("body");
        try {
            this.parser.reset();
            NodeList nodeList = this.parser.extractAllNodesThatMatch(filter);
            return nodeList;
        }
        catch (ParserException e) {
            return null;
        }
        finally {
            filter = null;
        }
    }
}

