/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Expr {
    public static final String chunker = "((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^\\[\\]]*\\]|['\"][^'\"]*['\"]|[^\\[\\]'\"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)";
    public static final String[] order = new String[]{"ID", "CLASS", "ATTR", "TAG"};
    public static final String[] filter = new String[]{"ID", "CLASS", "NAME", "ATTR", "TAG", "CHILD", "POS", "PSEUDO"};
    private static Map<String, String> match = null;
    private static Map<String, String> leftMatch = null;

    public static String match(String key) {
        Expr.initMatch();
        return match.get(key);
    }

    public static String match(String key, String expression) {
        String exp = Expr.match(key);
        return Expr.matcher(exp, expression);
    }

    public static String leftMatch(String key) {
        Expr.initLeftMatch();
        return leftMatch.get(key);
    }

    public static String leftMatch(String key, String expression) {
        String exp = Expr.leftMatch(key);
        return Expr.matcher(exp, expression);
    }

    private static String matcher(String expr, String expression) {
        Pattern pattern = Pattern.compile(expr);
        Matcher matcher = pattern.matcher(expression);
        String str = matcher.find() ? matcher.group(0) : null;
        matcher = null;
        pattern = null;
        return str;
    }

    private static void initMatch() {
        if (match != null) {
            return;
        }
        match = new HashMap<String, String>();
        match.put("ID", "/#((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("CLASS", "\\.((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("NAME", "\\[name=['\"]*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)['\"]*\\](?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("ATTR", "\\[\\s*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['\"]*)(.*?)\\3|)\\s*\\](?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("TAG", "((?:[\\w\\u00c0-\\uFFFF\\*\\-]|\\\\.)+)(?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("CHILD", ":(only|nth|last|first)-child(?:\\((even|odd|[\\dn+\\-]*)\\))?(?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("POS", ":(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^\\-]|$)(?![^\\[]*\\])(?![^\\(]*\\))");
        match.put("PSEUDO", ":((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?:\\((['\"]?)((?:\\([^\\)]+\\)|[^\\(\\)]*)+)\\2\\))?(?![^\\[]*\\])(?![^\\(]*\\))");
    }

    private static void initLeftMatch() {
        if (leftMatch != null) {
            return;
        }
        leftMatch = new HashMap<String, String>();
        leftMatch.put("ID", "(^(?:.|\\r|\\n)*?)#((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("CLASS", "(^(?:.|\\r|\\n)*?)\\.((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("NAME", "(?:.|\\r|\\n)*?)\\[name=['\"]*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)['\"]*\\](?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("ATTR", "(^(?:.|\\r|\\n)*?)\\[\\s*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['\"]*)(.*?)\\4|)\\s*\\](?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("TAG", "(^(?:.|\\r|\\n)*?)^((?:[\\w\\u00c0-\\uFFFF\\*\\-]|\\\\.)+)(?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("CHILD", "(^(?:.|\\r|\\n)*?):(only|nth|last|first)-child(?:\\((even|odd|[\\dn+\\-]*)\\))?(?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("POS", "(^(?:.|\\r|\\n)*?):(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^\\-]|$)(?![^\\[]*\\])(?![^\\(]*\\))");
        leftMatch.put("PSEUDO", "(^(?:.|\\r|\\n)*?):((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?:\\((['\"]?)((?:\\([^\\)]+\\)|[^\\(\\)]*)+)\\3\\))?(?![^\\[]*\\])(?![^\\(]*\\))");
    }
}

