/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.web.config;

import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.R;
import com.alibaba.csp.sentinel.Tracer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Configuration
@ConditionalOnMissingBean(value={UnifyExceptionHandler.class})
public class UnifyExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(UnifyExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public R exceptionHandler(HttpServletRequest request, Exception e) {
        Tracer.trace((Throwable)e);
        String msg = e.getMessage();
        if (e instanceof BindException) {
            msg = ((BindException)e).getBindingResult().getFieldErrors().stream().map(v -> v.getDefaultMessage()).collect(Collectors.joining(","));
        }
        log.error("\u7cfb\u7edf\u4e25\u91cd\u9519\u8bef", (Throwable)e);
        return R.failed((String)msg);
    }

    @ResponseBody
    @ExceptionHandler(value={RuntimeException.class})
    public R runtimeException(HttpServletRequest request, RuntimeException e) {
        log.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        if (e instanceof BusinessException) {
            BusinessException ex = (BusinessException)e;
            return R.failed((String)e.getMessage()).setCode(ex.getCode());
        }
        if (e.getCause() instanceof BusinessException) {
            BusinessException ex = (BusinessException)e.getCause();
            return R.failed((String)e.getMessage()).setCode(ex.getCode());
        }
        return this.exceptionHandler(request, e);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnifyExceptionHandler)) {
            return false;
        }
        UnifyExceptionHandler other = (UnifyExceptionHandler)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnifyExceptionHandler;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "UnifyExceptionHandler()";
    }
}

