/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.web.config;

import cn.bctools.common.utils.ObjectNull;
import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.common.utils.SystemThreadLocal;
import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.web.config.EnumConvertorFactory;
import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnMissingBean(value={JvsWebMvcConfigurer.class})
public class JvsWebMvcConfigurer
implements WebMvcConfigurer,
ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JvsWebMvcConfigurer.class);

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new HandlerInterceptor(){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
                String version = request.getHeader("jvs-rule-ua");
                String tenantId = request.getHeader("jvs-tenantId");
                SystemThreadLocal.set((String)"jvs-rule-ua", (Object)version);
                if (ObjectNull.isNull((Object[])new Object[]{TenantContextHolder.getTenantId()})) {
                    TenantContextHolder.setTenantId((String)tenantId);
                }
                MDC.put((String)"TraceId", (String)TraceContext.traceId());
                MDC.put((String)"env", (String)SpringContextUtil.getEnv());
                return true;
            }

            public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
                String tenantId = request.getHeader("jvs-tenantId");
                if (ObjectNull.isNull((Object[])new Object[]{TenantContextHolder.getTenantId()})) {
                    TenantContextHolder.setTenantId((String)tenantId);
                }
                String header = request.getHeader("jvs-rule-ua");
                SystemThreadLocal.set((String)"jvs-rule-ua", (Object)header);
                MDC.put((String)"TraceId", (String)TraceContext.traceId());
                MDC.put((String)"env", (String)SpringContextUtil.getEnv());
            }
        }).addPathPatterns(new String[]{"/**"});
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String tenantId;
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request);
        String version = (String)SystemThreadLocal.get((String)"jvs-rule-ua");
        if (ObjectUtil.isNotEmpty((Object)version)) {
            requestWrapper.getHeaders().add("jvs-rule-ua", version);
        }
        if (ObjectUtil.isNotEmpty((Object)(tenantId = (String)SystemThreadLocal.get((String)"jvs-tenantId")))) {
            requestWrapper.getHeaders().add("jvs-tenantId", tenantId);
        }
        return execution.execute((HttpRequest)requestWrapper, body);
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory((ConverterFactory)new EnumConvertorFactory());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JvsWebMvcConfigurer)) {
            return false;
        }
        JvsWebMvcConfigurer other = (JvsWebMvcConfigurer)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof JvsWebMvcConfigurer;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "JvsWebMvcConfigurer()";
    }
}

