/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.web.config;

import cn.bctools.common.utils.SystemThreadLocal;
import cn.hutool.core.util.ObjectUtil;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
@Order(value=-2147483647)
public class ContextHolderFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(ContextHolderFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        String tenantId;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String version = request.getHeader("jvs-rule-ua");
        if (ObjectUtil.isNotEmpty((Object)version)) {
            SystemThreadLocal.set((String)"jvs-rule-ua", (Object)version);
        }
        if (ObjectUtil.isNotEmpty((Object)(tenantId = request.getHeader("jvs-tenantId")))) {
            SystemThreadLocal.set((String)"jvs-tenantId", (Object)tenantId);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        SystemThreadLocal.clear();
    }
}

