/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.sms.utils;

import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.sms.config.AliSmsConfig;
import cn.bctools.sms.utils.SmsTemplate;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsSendUtils {
    private static final Logger log = LoggerFactory.getLogger(SmsSendUtils.class);
    public static final String ALIYUN_SMS_SUCCESS_CODE = "OK";
    public static final String PRODUCT = "Dysmsapi";
    public static final String DOMAIN = "dysmsapi.aliyuncs.com";
    public static final String WRONG_KEY = "InvalidAccessKeyId.NotFound";
    public static final String WRONG_SECRET = "SDK.InvalidAccessKeySecret";
    private static final String LEFT = "${";
    private static final String RIGHT = "}";

    public static String replace(SmsTemplate smsTemplate, Map<String, Object> mappings) {
        String content = smsTemplate.getContent();
        for (String key : mappings.keySet()) {
            String keyword = LEFT + key + RIGHT;
            if (!content.contains(keyword)) continue;
            content = content.replace(keyword, mappings.get(key).toString());
        }
        return content;
    }

    public static String smsCode() {
        String random = (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "";
        log.debug("\u521b\u5efa\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a{}", (Object)random);
        return random;
    }

    public static Object aliImpl(String templateCode, List<String> phones, Map<String, String> variables) {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        AliSmsConfig bean = (AliSmsConfig)SpringContextUtil.getBean(AliSmsConfig.class);
        String accessKeyId = bean.getAccessKeyId();
        String accessKeySecret = bean.getAccessKeySecret();
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)PRODUCT, (String)DOMAIN);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setSysMethod(MethodType.POST);
        request.setPhoneNumbers(String.join((CharSequence)",", phones));
        request.setSignName(bean.getSignature());
        request.setTemplateCode(templateCode);
        String templateParam = JSONObject.toJSONString(variables);
        request.setTemplateParam(templateParam);
        SendSmsResponse sendSmsResponse = null;
        try {
            log.info("\u77ed\u4fe1\u53d1\u9001\u53c2\u6570\u4e3a:{}", (Object)JSONObject.toJSONString((Object)request));
            sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            log.error("\u963f\u91cc\u4e91\u77ed\u4fe1,\u521d\u59cb\u5316\u77ed\u4fe1\u5ba2\u6237\u7aef\u5f02\u5e38", (Throwable)e);
            if (e.getMessage().startsWith(WRONG_KEY)) {
                throw new BusinessException("\u65e0\u6548\u7684\u8bbf\u95eekey(AccessKeyId)");
            }
            if (e.getMessage().startsWith(WRONG_SECRET)) {
                throw new BusinessException("\u65e0\u6548\u7684\u8bbf\u95ee\u79d8\u94a5(AccessKeySecret)");
            }
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u963f\u91cc\u4e91\u8d26\u53f7\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        if (sendSmsResponse == null) {
            log.error("\u963f\u91cc\u4e91\u77ed\u4fe1,\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38,sendSmsResponse\u54cd\u5e94\u5bf9\u8c61\u4e3anull");
            throw new BusinessException("\u963f\u91cc\u4e91\u77ed\u4fe1,\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38,\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u672a\u6536\u5230\u54cd\u5e94");
        }
        if (sendSmsResponse.getCode() != null && ALIYUN_SMS_SUCCESS_CODE.equals(sendSmsResponse.getCode())) {
            log.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f,{}", (Object)JSONObject.toJSONString((Object)sendSmsResponse));
            return sendSmsResponse;
        }
        String message = sendSmsResponse.getMessage();
        log.error("\u963f\u91cc\u4e91\u77ed\u4fe1:{}", (Object)message);
        throw new BusinessException("\u963f\u91cc\u4e91\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38,{}, \u5f53\u524d\u6a21\u677f:{}", new Object[]{message, templateCode});
    }
}

