/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.sentinel.config;

import cn.bctools.common.utils.R;
import com.alibaba.cloud.sentinel.feign.SentinelFeign;
import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.fastjson.JSONObject;
import feign.Feign;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={SentinelFeignAutoConfiguration.class})
public class SentinelConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"feign.sentinel.enabled"})
    public Feign.Builder feignSentinelBuilder() {
        return SentinelFeign.builder();
    }

    @Configuration
    @ConditionalOnClass(value={HttpServletRequest.class})
    public static class WebmvcHandler {
        @Bean
        public BlockExceptionHandler webmvcBlockExceptionHandler() {
            return (request, response, e) -> {
                response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
                R result = R.failed((String)"Too many request, please retry later.");
                response.getWriter().print(JSONObject.toJSONString((Object)result));
            };
        }
    }
}

