/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.feign.config;

import cn.bctools.feign.config.SwaggerProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@Configuration
public class SwaggerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Docket.class})
    public Docket defaultApi2(SwaggerProperties swaggerProperties) {
        return new Docket(DocumentationType.SWAGGER_2).enable(Boolean.TRUE.equals(swaggerProperties.getEnable())).apiInfo(new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).build()).securitySchemes(new ArrayList<ApiKey>(this.apiKey())).securityContexts(new ArrayList<SecurityContext>(this.securityContexts())).select().apis(RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage())).paths(PathSelectors.any()).build();
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference("Authorization", authorizationScopes));
        return securityReferences;
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
        return securityContexts;
    }

    private List<ApiKey> apiKey() {
        ApiKey apiKey = new ApiKey("Authorization", "Authorization", "header");
        ArrayList<ApiKey> arrayList = new ArrayList<ApiKey>();
        arrayList.add(apiKey);
        return arrayList;
    }
}

