/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.gray.rule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.NacosServiceInstance;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;
import reactor.core.publisher.Mono;

public class VersionLoadBalancer
extends RoundRobinLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(VersionLoadBalancer.class);
    private final String serviceId;
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;

    public VersionLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId) {
        super(serviceInstanceListSupplierProvider, serviceId);
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.serviceId = serviceId;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> this.getInstanceResponse((List<ServiceInstance>)serviceInstances, request));
    }

    Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances, Request request) {
        if (CollUtil.isEmpty(instances)) {
            log.warn("No instance available. serviceId: {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        if (request == null || request.getContext() == null) {
            return new DefaultResponse((ServiceInstance)RandomUtil.randomEle(instances));
        }
        DefaultRequestContext requestContext = (DefaultRequestContext)request.getContext();
        if (!(requestContext.getClientRequest() instanceof RequestData)) {
            return new DefaultResponse((ServiceInstance)RandomUtil.randomEle(instances));
        }
        RequestData clientRequest = (RequestData)requestContext.getClientRequest();
        HttpHeaders headers = clientRequest.getHeaders();
        String reqVersion = headers.getFirst("jvs-rule-ua");
        if (!StrUtil.isNotBlank((CharSequence)reqVersion)) {
            log.info("No version found");
            return new DefaultResponse((ServiceInstance)RandomUtil.randomEle(instances));
        }
        reqVersion = URLDecoder.decode(reqVersion);
        String finalReqVersion = reqVersion;
        List matchedInstances = instances.stream().filter(instance -> {
            NacosServiceInstance nacosInstance = (NacosServiceInstance)instance;
            Map metadata = nacosInstance.getMetadata();
            String targetVersion = MapUtil.getStr((Map)metadata, (Object)"jvs-rule-ua", (String)"-");
            return targetVersion.contains(finalReqVersion);
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(matchedInstances)) {
            log.info("Found {} matched instance, returns a random one. serviceId: {}, version: {}", new Object[]{matchedInstances.size(), this.serviceId, reqVersion});
            return new DefaultResponse((ServiceInstance)RandomUtil.randomEle(matchedInstances));
        }
        log.warn("No instance matched. serviceId: {}, version: {}", (Object)this.serviceId, (Object)reqVersion);
        return new DefaultResponse((ServiceInstance)RandomUtil.randomEle(instances));
    }
}

