/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.gray.config;

import cn.bctools.gray.rule.VersionLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class GrayLoadBalancerClientConfiguration
extends LoadBalancerClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrayLoadBalancerClientConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ReactorLoadBalancer<ServiceInstance> serviceInstanceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new VersionLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
    }
}

