/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.feign.config;

import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.R;
import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.common.utils.SystemThreadLocal;
import cn.bctools.common.utils.TenantContextHolder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import feign.RequestInterceptor;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
public class FeignEncodingConfig {
    private static final Logger log = LoggerFactory.getLogger(FeignEncodingConfig.class);
    @Autowired
    private ObjectFactory<HttpMessageConverters> messageConverters;
    private static final String DEFAULT_TENANT_ID = "1";

    @Bean
    @ConditionalOnMissingBean
    public RequestInterceptor jvsRequestInterceptor() {
        return requestTemplate -> {
            String tenantId;
            String applicationContextName = SpringContextUtil.getApplicationContextName();
            requestTemplate.header("_application_name_", new String[]{applicationContextName});
            Object version = SystemThreadLocal.get((String)"jvs-rule-ua");
            if (ObjectUtil.isNotEmpty((Object)version)) {
                requestTemplate.header("jvs-rule-ua", new String[]{String.valueOf(version)});
            }
            if (StrUtil.isBlank((CharSequence)(tenantId = TenantContextHolder.getTenantId()))) {
                tenantId = DEFAULT_TENANT_ID;
                log.trace("Empty tenant id in context, using default : " + tenantId);
            }
            requestTemplate.header("jvs-tenantId", new String[]{tenantId});
            log.trace("\u53d1\u9001Feign\u8bf7\u6c42: {}, \u4f20\u9012\u79df\u6237\uff1a{}, \u4f20\u9012token: {}", new Object[]{requestTemplate.path(), tenantId, requestTemplate.headers().get("Authorization")});
        };
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    @ConditionalOnMissingBean(value={Encoder.class})
    public Encoder feignFormEncoder() {
        return new SpringFormEncoder((Encoder)new SpringEncoder(this.messageConverters));
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    @ConditionalOnMissingBean(value={Decoder.class})
    public Decoder decoder() {
        return new SpringDecoder(this.messageConverters){

            public Object decode(Response response, Type type) throws IOException {
                Object decode = super.decode(response, type);
                if (ObjectUtil.isNotEmpty((Object)decode)) {
                    log.trace("\u89e3\u7801\u540e\u7684\u7ed3\u679c\u4e3a:{}", (Object)decode.toString());
                }
                if (decode instanceof R) {
                    R r = (R)decode;
                    if (r.is()) {
                        log.trace("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u6210\u529f");
                        return decode;
                    }
                    log.error("FeignClient\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a:{},\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Object)JSONObject.toJSONString((Object)decode), (Object)r.getMsg());
                    throw new BusinessException(r.getMsg(), r.getCode());
                }
                return decode;
            }
        };
    }
}

