/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.util;

import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.database.entity.DatabaseInfo;
import cn.bctools.database.getter.DefaultTableFieldGetter;
import cn.bctools.database.property.SqlProperties;
import cn.bctools.database.util.DatabaseUtils;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantDynamicDatasourceUtil {
    private static final Logger log = LoggerFactory.getLogger(TenantDynamicDatasourceUtil.class);
    private static String createDatabasesSql = "CREATE DATABASE IF NOT EXISTS %s DEFAULT CHARSET utf8mb4 COLLATE utf8mb4_general_ci;";
    private static String createTableTemplate = "CREATE TABLE IF NOT EXISTS %s.`";
    private static String insertTemplate = "INSERT INTO %s.`";
    public static final String NAME_JOINER = "_";
    private static final String INIT_DATA_FILE_NAME = "init.sql";
    private static Set<String> databaseInitialized = new HashSet<String>();

    private TenantDynamicDatasourceUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean init() {
        SqlProperties sqlProperties = (SqlProperties)SpringContextUtil.getBean(SqlProperties.class);
        if (!sqlProperties.isDynamicTenantDatabase()) {
            return true;
        }
        String tenantId = TenantContextHolder.getTenantId();
        String databaseName = "";
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        try (Connection connection = dataSource.getConnection();){
            String url = connection.getMetaData().getURL();
            DatabaseInfo info = DatabaseUtils.parseUrl(url);
            databaseName = info.getDatabaseName() + NAME_JOINER + tenantId;
            String format = String.format(createDatabasesSql, databaseName);
            if (Boolean.FALSE.equals(databaseInitialized.contains(databaseName))) {
                log.info("\u521d\u59cb\u5316\u6570\u636e\u5e93{}\u5f00\u59cb", (Object)databaseName);
                dataSource.getConnection().createStatement().execute(format);
                TenantDynamicDatasourceUtil.initTable(databaseName, connection);
                TenantDynamicDatasourceUtil.initData(databaseName, connection);
                databaseInitialized.add(databaseName);
                log.info("\u521d\u59cb\u5316\u6570\u636e\u5e93{}\u7ed3\u675f", (Object)databaseName);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException throwables) {
            log.error("\u521d\u59cb\u5316\u6570\u636e\u5e93\u5931\u8d25. \u79df\u6237: {}, \u5e93\u540d: {}, exception: {}", new Object[]{tenantId, databaseName, throwables.getMessage()});
            return false;
        }
    }

    public static void initTable(String databaseName, Connection conn) {
        DefaultTableFieldGetter.getTableList().forEach(tableName -> {
            String sql = "SHOW CREATE TABLE " + tableName;
            try {
                ResultSet resultSet = conn.createStatement().executeQuery(sql);
                while (resultSet.next()) {
                    String createTableSql = resultSet.getString(2).replace("CREATE TABLE `", String.format(createTableTemplate, databaseName)) + ";";
                    conn.createStatement().execute(createTableSql);
                }
            }
            catch (SQLException throwables) {
                log.error("\u521d\u59cb\u5316\u8868\u5931\u8d25. \u5e93\u540d: {}, \u8868\u540d: {}, exception: {}", new Object[]{databaseName, tableName, throwables.getMessage()});
            }
        });
    }

    public static void initData(String databaseName, Connection conn) {
        try {
            String defaultDataSql = ResourceUtil.readUtf8Str((String)INIT_DATA_FILE_NAME);
            if (StringUtils.isBlank((CharSequence)defaultDataSql)) {
                return;
            }
            defaultDataSql = defaultDataSql.replace("INSERT INTO `", String.format(insertTemplate, databaseName));
            ScriptRunner runner = new ScriptRunner(conn);
            runner.setSendFullScript(Boolean.FALSE.booleanValue());
            runner.runScript((Reader)StrUtil.getReader((CharSequence)defaultDataSql));
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38\u3002exception: {}", (Object)e.getMessage());
        }
    }
}

