/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.util;

import cn.bctools.common.exception.BusinessException;
import cn.bctools.database.entity.DatabaseInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtils {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtils.class);

    private DatabaseUtils() {
    }

    public static DatabaseInfo parseUrl(String url) {
        DatabaseInfo info = new DatabaseInfo();
        String[] subUrl = url.split("/", 4);
        if (subUrl.length != 4) {
            log.error("\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u5f02\u5e38: {}", (Object)url);
            throw new BusinessException("\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u5f02\u5e38");
        }
        String[] split = subUrl[2].split(":");
        if (split.length == 1) {
            info.setIp(split[0]);
        } else if (split.length == 2) {
            info.setIp(split[0]);
            info.setPort(split[1]);
        } else {
            log.error("\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u5f02\u5e38: {}", (Object)url);
            throw new BusinessException("\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u5f02\u5e38");
        }
        String databaseName = subUrl[3].split("\\?")[0];
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            log.error("\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u5f02\u5e38: {}", (Object)url);
            throw new BusinessException("\u6570\u636e\u6e90\u8fde\u63a5url\u683c\u5f0f\u5f02\u5e38");
        }
        info.setDatabaseName(databaseName);
        return info;
    }
}

