/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.interceptor.tenant;

import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.database.interceptor.tenant.JvsTenantHandler;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvsTenantLineInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JvsTenantLineInnerInterceptor.class);
    private JvsTenantHandler jvsTenantHandler;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
            return;
        }
        if (SqlParserHelper.getSqlParserInfo((MappedStatement)ms)) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
                return;
            }
            if (SqlParserHelper.getSqlParserInfo((MappedStatement)ms)) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    public void processSelect(Select select, int index, String sql, Object obj) {
        this.processSelectBody(select.getSelectBody());
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(this::processSelectBody);
        }
    }

    private void processSelectBody(SelectBody selectBody) {
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            this.processSelectBody(withItem.getSelectBody());
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    public void processInsert(Insert insert, int index, String sql, Object obj) {
        Table table = insert.getTable();
        if (this.jvsTenantHandler.ignoreTable(table.getName())) {
            return;
        }
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.jvsTenantHandler.getTenantIdColumn();
        if (columns.stream().map(Column::getColumnName).anyMatch(i -> i.equals(tenantIdColumn))) {
            return;
        }
        columns.add(new Column(this.jvsTenantHandler.getTenantIdColumn()));
        Select select = insert.getSelect();
        if (select != null) {
            this.processInsertSelect(select.getSelectBody());
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExprList().forEach(el -> el.getExpressions().add(this.jvsTenantHandler.getTenantId()));
            } else {
                ((ExpressionList)itemsList).getExpressions().add(this.jvsTenantHandler.getTenantId());
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    public void processUpdate(Update update, int index, String sql, Object obj) {
        Table table = update.getTable();
        if (this.jvsTenantHandler.ignoreTable(table.getName())) {
            return;
        }
        update.setWhere(this.shareTenantIdExpression(table, update.getWhere()));
    }

    public void processDelete(Delete delete, int index, String sql, Object obj) {
        Table table = delete.getTable();
        if (this.jvsTenantHandler.ignoreTable(table.getName())) {
            return;
        }
        delete.setWhere(this.shareTenantIdExpression(table, delete.getWhere()));
    }

    protected void processInsertSelect(SelectBody selectBody) {
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            plainSelect.setWhere(this.shareTenantIdExpression(fromTable, plainSelect.getWhere()));
            this.appendSelectItem(plainSelect.getSelectItems());
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.appendSelectItem(plainSelect.getSelectItems());
            this.processInsertSelect(subSelect.getSelectBody());
        }
    }

    protected void appendSelectItem(List<SelectItem> selectItems) {
        SelectItem item;
        if (CollectionUtils.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && ((item = selectItems.get(0)) instanceof AllColumns || item instanceof AllTableColumns)) {
            return;
        }
        selectItems.add((SelectItem)new SelectExpressionItem((Expression)new Column(this.jvsTenantHandler.getTenantIdColumn())));
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where);
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.jvsTenantHandler.ignoreTable(fromTable.getName())) {
                plainSelect.setWhere(this.shareTenantIdExpression(fromTable, where));
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
    }

    protected void processWhereSubSelect(Expression where) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processFromItem((FromItem)where);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression());
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                ItemsList itemsList = expression.getRightItemsList();
                if (itemsList instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)itemsList).getSelectBody());
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression());
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression());
            }
        }
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                subJoin.getJoinList().forEach(this::processJoin);
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        if (join.getRightItem() instanceof Table) {
            Table fromTable = (Table)join.getRightItem();
            if (this.jvsTenantHandler.ignoreTable(fromTable.getName())) {
                return;
            }
            join.setOnExpression(this.shareTenantIdExpression(fromTable, join.getOnExpression()));
        }
    }

    protected Expression shareTenantIdExpression(Table table, Expression where) {
        String tenantId = TenantContextHolder.getTenantId();
        if (ObjectUtil.isNotEmpty((Object)tenantId)) {
            log.info(">>>> \u79df\u6237\u6743\u9650\u62e6\u622a tenant_id=\u5f53\u524d\u7ebf\u7a0b\u79df\u6237id:{}", (Object)TenantContextHolder.getTenantId());
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
            equalsTo.setRightExpression(this.jvsTenantHandler.getTenantId());
            where = JvsTenantLineInnerInterceptor.buildShareTenantIdExpression(where, (Expression)equalsTo);
        }
        return where;
    }

    protected static Expression buildShareTenantIdExpression(Expression currentExpression, Expression expression) {
        if (currentExpression == null) {
            return expression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), expression);
        }
        return new AndExpression(currentExpression, expression);
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName()).append(".");
        }
        column.append(this.jvsTenantHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public void setProperties(Properties properties) {
        PropertyMapper.newInstance((Properties)properties).whenNotBlack("jvsTenantHandler", ClassUtils::newInstance, this::setJvsTenantHandler);
    }

    public JvsTenantHandler getJvsTenantHandler() {
        return this.jvsTenantHandler;
    }

    public void setJvsTenantHandler(JvsTenantHandler jvsTenantHandler) {
        this.jvsTenantHandler = jvsTenantHandler;
    }

    public JvsTenantLineInnerInterceptor() {
    }

    public JvsTenantLineInnerInterceptor(JvsTenantHandler jvsTenantHandler) {
        this.jvsTenantHandler = jvsTenantHandler;
    }

    public String toString() {
        return "JvsTenantLineInnerInterceptor(super=" + super.toString() + ", jvsTenantHandler=" + this.getJvsTenantHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JvsTenantLineInnerInterceptor)) {
            return false;
        }
        JvsTenantLineInnerInterceptor other = (JvsTenantLineInnerInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvsTenantHandler this$jvsTenantHandler = this.getJvsTenantHandler();
        JvsTenantHandler other$jvsTenantHandler = other.getJvsTenantHandler();
        return !(this$jvsTenantHandler == null ? other$jvsTenantHandler != null : !this$jvsTenantHandler.equals(other$jvsTenantHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JvsTenantLineInnerInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JvsTenantHandler $jvsTenantHandler = this.getJvsTenantHandler();
        result = result * 59 + ($jvsTenantHandler == null ? 43 : $jvsTenantHandler.hashCode());
        return result;
    }
}

