/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.interceptor.tenant;

import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.database.entity.DatabaseInfo;
import cn.bctools.database.getter.IDataSourceGetter;
import cn.bctools.database.getter.ITableFieldGetter;
import cn.bctools.database.util.TenantDynamicDatasourceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JvsTenantHandler {
    private static final Logger log = LoggerFactory.getLogger(JvsTenantHandler.class);
    @Autowired
    private ITableFieldGetter tableFieldGetter;
    @Autowired
    private IDataSourceGetter dataSourceGetter;
    private static final String TENANT_ID = "tenant_id";

    public Expression getTenantId() {
        String tenantId = TenantContextHolder.getTenantId();
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            log.error("\u83b7\u53d6\u79df\u6237\u4e3a\u7a7a:\u8bf7\u68c0\u67e5SQL\u6570\u636e>> ");
            return new NullValue();
        }
        return new StringValue(tenantId);
    }

    public String getTenantIdColumn() {
        return TENANT_ID;
    }

    public boolean ignoreTable(String tableName) {
        tableName = tableName.replace("`", "");
        String tenantId = TenantContextHolder.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            log.info("\u5f53\u524d\u7ebf\u7a0b\u4e2d\u6ca1\u6709\u79df\u6237id, \u8df3\u8fc7\u79df\u6237\u62e6\u622a");
            return true;
        }
        DatabaseInfo databaseInfo = this.dataSourceGetter.getCurrent();
        List<String> tableFieldNames = this.tableFieldGetter.getFieldNames(databaseInfo.getIp(), databaseInfo.getPort(), databaseInfo.getDatabaseName(), tableName);
        if (ObjectUtils.isEmpty(tableFieldNames)) {
            log.info("\u6570\u636e\u8868{}\u6ca1\u6709\u627e\u5230, \u8df3\u8fc7\u79df\u6237\u62e6\u622a", (Object)tableName);
            return true;
        }
        if (!tableFieldNames.contains(TENANT_ID)) {
            log.info("\u6570\u636e\u8868{}\u6ca1\u6709{}\u5b57\u6bb5\uff0c\u8df3\u8fc7\u79df\u6237\u62e6\u622a", (Object)tableName, (Object)TENANT_ID);
            return true;
        }
        return !TenantDynamicDatasourceUtil.init();
    }
}

