/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.interceptor.performance;

import cn.bctools.common.utils.ObjectNull;
import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.database.property.SqlProperties;
import cn.hutool.db.sql.SqlFormatter;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.SystemClock;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
@Configuration
@RefreshScope
public class SQLPerformanceInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SQLPerformanceInterceptor.class);
    private static final String DRUID_POOLED_PREPARED_STATEMENT = "com.alibaba.druid.pool.DruidPooledPreparedStatement";
    private static final String T4C_PREPARED_STATEMENT = "oracle.jdbc.driver.T4CPreparedStatement";
    private static final String ORACLE_PREPARED_STATEMENT_WRAPPER = "oracle.jdbc.driver.OraclePreparedStatementWrapper";
    private Method oracleGetOriginalSqlMethod;
    private Method druidGetSqlMethod;
    @Resource
    SqlProperties sqlProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        JdbcTemplate jdbcTemplate;
        if (!this.sqlProperties.isLog()) {
            return invocation.proceed();
        }
        String originalSql = this.getSql(invocation);
        long start = SystemClock.now();
        Object result = invocation.proceed();
        if (this.sqlProperties.isExplainIs() && (originalSql.trim().startsWith("select") || originalSql.trim().startsWith("SELECT")) && ObjectNull.isNotNull((Object[])new Object[]{jdbcTemplate = (JdbcTemplate)SpringContextUtil.getBean(JdbcTemplate.class)})) {
            List<Map<String, Object>> accessType = this.getAccessType(originalSql, jdbcTemplate);
            long end = SystemClock.now();
            long timing = end - start;
            try {
                this.logRecord(originalSql, invocation.getTarget(), accessType, start, end, timing);
            }
            catch (Exception exception) {
                log.error("\u4fdd\u5b58SQL\u65e5\u5fd7\u8bb0\u5f55\u51fa\u9519", (Throwable)exception);
            }
        }
        return result;
    }

    private List<Map<String, Object>> getAccessType(String originalSql, JdbcTemplate jdbcTemplate) {
        String explainSql = "Explain " + originalSql;
        List mapList = jdbcTemplate.queryForList(explainSql);
        return mapList;
    }

    @Async
    public void logRecord(String originalSql, Object targetR, List<Map<String, Object>> accessType, long start, long end, long timing) {
        boolean goodSql;
        Object target = PluginUtils.realTarget((Object)targetR);
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        originalSql = SqlFormatter.format((String)originalSql);
        StringBuilder formatSql = new StringBuilder().append(" Time:").append(timing).append(" ms - ID:").append(ms.getId()).append("\n").append("Execute SQL:").append(originalSql).append("\n");
        String applicationContextName = SpringContextUtil.getApplicationContextName();
        boolean bl = goodSql = timing < this.sqlProperties.getMaxTime();
        if (goodSql) {
            log.debug(formatSql.toString());
        } else {
            log.error("\u8bf7\u4f18\u5316SQL! The SQL execution time is too large, please optimize ! SQL:  \u3010" + formatSql.toString() + "\u3011 consumingTime:{},  explus:{}", (Object)timing, accessType);
        }
    }

    private String getSql(Invocation invocation) {
        int index;
        Object stmtSql;
        Class<?> clazz;
        Object firstArg = invocation.getArgs()[0];
        Statement statement = Proxy.isProxyClass(firstArg.getClass()) ? (Statement)SystemMetaObject.forObject((Object)firstArg).getValue("h.statement") : (Statement)firstArg;
        MetaObject stmtMetaObj = SystemMetaObject.forObject((Object)statement);
        try {
            statement = (Statement)stmtMetaObj.getValue("stmt.statement");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stmtMetaObj.hasGetter("delegate")) {
            try {
                statement = (Statement)stmtMetaObj.getValue("delegate");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String originalSql = null;
        String stmtClassName = statement.getClass().getName();
        if (DRUID_POOLED_PREPARED_STATEMENT.equals(stmtClassName)) {
            try {
                if (this.druidGetSqlMethod == null) {
                    clazz = Class.forName(DRUID_POOLED_PREPARED_STATEMENT);
                    this.druidGetSqlMethod = clazz.getMethod("getSql", new Class[0]);
                }
                if ((stmtSql = this.druidGetSqlMethod.invoke((Object)statement, new Object[0])) instanceof String) {
                    originalSql = (String)stmtSql;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (T4C_PREPARED_STATEMENT.equals(stmtClassName) || ORACLE_PREPARED_STATEMENT_WRAPPER.equals(stmtClassName)) {
            try {
                if (this.oracleGetOriginalSqlMethod != null) {
                    stmtSql = this.oracleGetOriginalSqlMethod.invoke((Object)statement, new Object[0]);
                    if (stmtSql instanceof String) {
                        originalSql = (String)stmtSql;
                    }
                } else {
                    clazz = Class.forName(stmtClassName);
                    this.oracleGetOriginalSqlMethod = this.getMethodRegular(clazz, "getOriginalSql");
                    if (this.oracleGetOriginalSqlMethod != null) {
                        Object stmtSql2;
                        this.oracleGetOriginalSqlMethod.setAccessible(true);
                        if (null != this.oracleGetOriginalSqlMethod && (stmtSql2 = this.oracleGetOriginalSqlMethod.invoke((Object)statement, new Object[0])) instanceof String) {
                            originalSql = (String)stmtSql2;
                        }
                    }
                }
            }
            catch (Exception clazz2) {
                // empty catch block
            }
        }
        if (originalSql == null) {
            originalSql = statement.toString();
        }
        if ((index = this.indexOfSqlStart(originalSql = originalSql.replaceAll("[\\s]+", " "))) > 0) {
            originalSql = originalSql.substring(index);
        }
        return originalSql;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public Method getMethodRegular(Class<?> clazz, String methodName) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return this.getMethodRegular(clazz.getSuperclass(), methodName);
    }

    private int indexOfSqlStart(String sql) {
        String upperCaseSql = sql.toUpperCase();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(upperCaseSql.indexOf("SELECT "));
        set.add(upperCaseSql.indexOf("UPDATE "));
        set.add(upperCaseSql.indexOf("INSERT "));
        set.add(upperCaseSql.indexOf("DELETE "));
        set.remove(-1);
        if (CollectionUtils.isEmpty(set)) {
            return -1;
        }
        ArrayList list = new ArrayList(set);
        list.sort(Comparator.naturalOrder());
        return (Integer)list.get(0);
    }

    public Method getOracleGetOriginalSqlMethod() {
        return this.oracleGetOriginalSqlMethod;
    }

    public Method getDruidGetSqlMethod() {
        return this.druidGetSqlMethod;
    }

    public SqlProperties getSqlProperties() {
        return this.sqlProperties;
    }

    public void setOracleGetOriginalSqlMethod(Method oracleGetOriginalSqlMethod) {
        this.oracleGetOriginalSqlMethod = oracleGetOriginalSqlMethod;
    }

    public void setDruidGetSqlMethod(Method druidGetSqlMethod) {
        this.druidGetSqlMethod = druidGetSqlMethod;
    }

    public void setSqlProperties(SqlProperties sqlProperties) {
        this.sqlProperties = sqlProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLPerformanceInterceptor)) {
            return false;
        }
        SQLPerformanceInterceptor other = (SQLPerformanceInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$oracleGetOriginalSqlMethod = this.getOracleGetOriginalSqlMethod();
        Method other$oracleGetOriginalSqlMethod = other.getOracleGetOriginalSqlMethod();
        if (this$oracleGetOriginalSqlMethod == null ? other$oracleGetOriginalSqlMethod != null : !((Object)this$oracleGetOriginalSqlMethod).equals(other$oracleGetOriginalSqlMethod)) {
            return false;
        }
        Method this$druidGetSqlMethod = this.getDruidGetSqlMethod();
        Method other$druidGetSqlMethod = other.getDruidGetSqlMethod();
        if (this$druidGetSqlMethod == null ? other$druidGetSqlMethod != null : !((Object)this$druidGetSqlMethod).equals(other$druidGetSqlMethod)) {
            return false;
        }
        SqlProperties this$sqlProperties = this.getSqlProperties();
        SqlProperties other$sqlProperties = other.getSqlProperties();
        return !(this$sqlProperties == null ? other$sqlProperties != null : !((Object)this$sqlProperties).equals(other$sqlProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SQLPerformanceInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $oracleGetOriginalSqlMethod = this.getOracleGetOriginalSqlMethod();
        result = result * 59 + ($oracleGetOriginalSqlMethod == null ? 43 : ((Object)$oracleGetOriginalSqlMethod).hashCode());
        Method $druidGetSqlMethod = this.getDruidGetSqlMethod();
        result = result * 59 + ($druidGetSqlMethod == null ? 43 : ((Object)$druidGetSqlMethod).hashCode());
        SqlProperties $sqlProperties = this.getSqlProperties();
        result = result * 59 + ($sqlProperties == null ? 43 : ((Object)$sqlProperties).hashCode());
        return result;
    }

    public String toString() {
        return "SQLPerformanceInterceptor(oracleGetOriginalSqlMethod=" + this.getOracleGetOriginalSqlMethod() + ", druidGetSqlMethod=" + this.getDruidGetSqlMethod() + ", sqlProperties=" + this.getSqlProperties() + ")";
    }
}

