/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.interceptor.datascope;

import cn.bctools.common.entity.dto.DataDictDto;
import cn.bctools.common.entity.dto.DataScopeDto;
import cn.bctools.database.entity.DatabaseInfo;
import cn.bctools.database.getter.IDataSourceGetter;
import cn.bctools.database.getter.ITableFieldGetter;
import cn.bctools.database.interceptor.datascope.DataScopeContextHolder;
import cn.bctools.database.interceptor.datascope.IDataSourceExpressionHandler;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DataSourceExpressionHandlerImpl
implements IDataSourceExpressionHandler {
    private static final Logger log = LoggerFactory.getLogger(DataSourceExpressionHandlerImpl.class);
    @Autowired
    private ITableFieldGetter tableFieldGetter;
    @Autowired
    private IDataSourceGetter dataSourceGetter;
    public static final String CREATE_BY_ID = "create_by_id";
    public static final String DEPT_ID = "dept_id";
    public static final String JOB_ID = "job_id";

    @Override
    public Expression apply(Expression currentExpression, Table table) {
        String tableName = table.getName().replace("`", "");
        DatabaseInfo databaseInfo = this.dataSourceGetter.getCurrent();
        List<String> tableFieldNames = this.tableFieldGetter.getFieldNames(databaseInfo.getIp(), databaseInfo.getPort(), databaseInfo.getDatabaseName(), tableName);
        if (ObjectUtils.isEmpty(tableFieldNames)) {
            log.error(">>>> \u6ca1\u6709\u627e\u5230\u52a0\u8f7d\u7684\u6570\u636e\u8868{}\u5b57\u6bb5\u4fe1\u606f,\u6743\u9650\u589e\u5f3a\u5931\u8d25!", (Object)tableName);
            return currentExpression;
        }
        DataScopeDto dataScope = DataScopeContextHolder.getDataScope();
        List jobIds = dataScope.getJobIds();
        List deptIds = dataScope.getDeptIds();
        List createByIds = dataScope.getCreateByIds();
        boolean hasJob = tableFieldNames.contains(JOB_ID);
        boolean hasDept = tableFieldNames.contains(DEPT_ID);
        boolean hasCreateById = tableFieldNames.contains(CREATE_BY_ID);
        currentExpression = this.getExpression(currentExpression, table, CREATE_BY_ID, hasCreateById, createByIds, false);
        currentExpression = this.getExpression(currentExpression, table, JOB_ID, hasJob, jobIds, false);
        currentExpression = this.getExpression(currentExpression, table, DEPT_ID, hasDept, deptIds, false);
        List dataDictDto = dataScope.getDataDicts();
        if (ObjectUtils.isEmpty((Object)databaseInfo)) {
            return currentExpression;
        }
        for (DataDictDto dictDto : dataDictDto) {
            String columnName = dictDto.getValue();
            String columnValue = null;
            boolean hasColumn = tableFieldNames.contains(columnName);
            currentExpression = this.getExpression(currentExpression, table, columnName, hasColumn, columnValue);
        }
        return currentExpression;
    }

    private Expression getExpression(Expression currentExpression, Table table, String columnName, Boolean hasColumn, String columnValue) {
        if (StringUtils.isBlank((CharSequence)columnValue)) {
            return currentExpression;
        }
        return this.getExpression(currentExpression, table, columnName, hasColumn, Collections.singletonList(columnValue), true);
    }

    private Expression getExpression(Expression currentExpression, Table table, String columnName, Boolean hasColumn, Collection<String> columnValues, boolean and) {
        if (!hasColumn.booleanValue()) {
            log.error(">>>> \u6570\u636e\u8868{}\u6ca1\u6709{}\u5b57\u6bb5, \u6743\u9650\u589e\u5f3a\u5931\u8d25", (Object)table.getName(), (Object)columnName);
            return currentExpression;
        }
        if (ObjectUtils.isEmpty(columnValues)) {
            log.error(">>>> \u6570\u636e\u6743\u9650\u4e3a\u7a7a: {}, \u589e\u5f3a\u5931\u8d25", (Object)columnName);
            return currentExpression;
        }
        if (and || columnValues.size() == 1) {
            for (String columnValue : columnValues) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)this.getAliasColumn(table, columnName));
                equalsTo.setRightExpression((Expression)new StringValue(columnValue));
                currentExpression = DataSourceExpressionHandlerImpl.buildExpression(currentExpression, (Expression)equalsTo);
            }
        } else {
            InExpression inExpression = new InExpression((Expression)this.getAliasColumn(table, columnName), (ItemsList)new ExpressionList(columnValues.stream().distinct().map(StringValue::new).collect(Collectors.toList())));
            currentExpression = DataSourceExpressionHandlerImpl.buildExpression(currentExpression, (Expression)inExpression);
        }
        return currentExpression;
    }

    private static Expression buildExpression(Expression currentExpression, Expression expression) {
        if (currentExpression == null) {
            return expression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), expression);
        }
        return new AndExpression(currentExpression, expression);
    }

    private Column getAliasColumn(Table table, String field) {
        StringBuilder column = new StringBuilder();
        Alias alias = table.getAlias();
        if (alias != null) {
            column.append(alias.getName()).append(".");
        }
        column.append(field);
        return new Column(column.toString());
    }
}

