/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.interceptor.datascope;

import cn.bctools.common.entity.dto.DataScopeDto;
import cn.bctools.common.utils.ObjectNull;
import cn.bctools.database.interceptor.datascope.DataScopeContextHolder;
import cn.bctools.database.interceptor.datascope.IDataSourceExpressionHandler;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScopeInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    IDataSourceExpressionHandler dataSourceExpressionHandler;
    public static final String CREATE_BY_ID = "create_by_id";
    public static final String DEPT_ID = "dept_id";
    public static final String JOB_ID = "job_id";

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreDataPermission((String)ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
                return;
            }
            if (SqlParserHelper.getSqlParserInfo((MappedStatement)ms)) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        DataScopeDto dataScope = DataScopeContextHolder.getDataScope();
        if (ObjectNull.isNotNull((Object[])new Object[]{dataScope.getDataScopeType()})) {
            log.debug(">>>> \u6570\u636e\u6743\u9650\u62e6\u622a\uff0c\u5904\u7406\u524dsql\uff1a{}", (Object)select.toString());
            this.processSelectBody(select.getSelectBody());
            List withItemsList = select.getWithItemsList();
            if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
                withItemsList.forEach(this::processSelectBody);
            }
            log.debug(">>>> \u6570\u636e\u6743\u9650\u62e6\u622a\uff0c\u5904\u7406\u540esql\uff1a{}", (Object)select.toString());
        }
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            this.processSelectBody(withItem.getSelectBody());
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where);
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            plainSelect.setWhere(this.builderExpression(where, fromTable));
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
    }

    protected void processWhereSubSelect(Expression where) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processFromItem((FromItem)where);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression());
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                ItemsList itemsList = expression.getRightItemsList();
                if (itemsList instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)itemsList).getSelectBody());
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression());
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression());
            }
        }
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                subJoin.getJoinList().forEach(this::processJoin);
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            log.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        if (join.getRightItem() instanceof Table) {
            Table fromTable = (Table)join.getRightItem();
            join.setOnExpression(this.builderExpression(join.getOnExpression(), fromTable));
        }
    }

    protected Expression builderExpression(Expression currentExpression, Table table) {
        return this.dataSourceExpressionHandler.apply(currentExpression, table);
    }

    public IDataSourceExpressionHandler getDataSourceExpressionHandler() {
        return this.dataSourceExpressionHandler;
    }

    public void setDataSourceExpressionHandler(IDataSourceExpressionHandler dataSourceExpressionHandler) {
        this.dataSourceExpressionHandler = dataSourceExpressionHandler;
    }

    public DataScopeInterceptor(IDataSourceExpressionHandler dataSourceExpressionHandler) {
        this.dataSourceExpressionHandler = dataSourceExpressionHandler;
    }

    public DataScopeInterceptor() {
    }

    public String toString() {
        return "DataScopeInterceptor(super=" + super.toString() + ", dataSourceExpressionHandler=" + this.getDataSourceExpressionHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataScopeInterceptor)) {
            return false;
        }
        DataScopeInterceptor other = (DataScopeInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IDataSourceExpressionHandler this$dataSourceExpressionHandler = this.getDataSourceExpressionHandler();
        IDataSourceExpressionHandler other$dataSourceExpressionHandler = other.getDataSourceExpressionHandler();
        return !(this$dataSourceExpressionHandler == null ? other$dataSourceExpressionHandler != null : !this$dataSourceExpressionHandler.equals(other$dataSourceExpressionHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataScopeInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IDataSourceExpressionHandler $dataSourceExpressionHandler = this.getDataSourceExpressionHandler();
        result = result * 59 + ($dataSourceExpressionHandler == null ? 43 : $dataSourceExpressionHandler.hashCode());
        return result;
    }
}

