/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.init;

import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.database.entity.DatabaseInfo;
import cn.bctools.database.entity.TableInfo;
import cn.bctools.database.getter.DefaultDataSourceGetter;
import cn.bctools.database.getter.DefaultTableFieldGetter;
import cn.bctools.database.getter.IDataSourceGetter;
import cn.bctools.database.getter.ITableFieldGetter;
import cn.bctools.database.mapper.TableInfoMapper;
import cn.bctools.database.util.DatabaseUtils;
import java.sql.Connection;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class DataSourceInit
extends SpringContextUtil {
    private static final Logger log = LoggerFactory.getLogger(DataSourceInit.class);
    @Resource
    private TableInfoMapper tableInfoMapper;
    private static Boolean isTenantId = false;
    private static final String DDL_SQL_PERFORMANCE = "CREATE TABLE IF NOT EXISTS  `sql_performance` (\n\t`id` INT ( 20 ) NOT NULL AUTO_INCREMENT COMMENT '\u4e3b\u952e',\n\t`sql` VARCHAR ( 255 ) DEFAULT NULL,\n\t`start_time` INT ( 11 ) DEFAULT NULL,\n\t`end_time` INT ( 11 ) DEFAULT NULL,\n\t`consuming_time` INT ( 11 ) DEFAULT NULL,\n\t`access_type` VARCHAR ( 50 ) DEFAULT NULL,\n\t`slow_sql` VARCHAR ( 255 ) DEFAULT NULL,\n\t`app_name` VARCHAR ( 50 ) DEFAULT NULL,\nPRIMARY KEY ( `id` ) \n) ENGINE = INNODB AUTO_INCREMENT = 2 DEFAULT CHARSET = utf8mb4 COMMENT = '\u4fdd\u5b58\u6267\u884c\u8ba1\u5212\u8868';";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        log.info("[mysql-data] \u52a0\u8f7d\u5355\u4e2a\u6570\u636e\u6e90");
        ITableFieldGetter tableFieldGetter = (ITableFieldGetter)SpringContextUtil.getBean(ITableFieldGetter.class);
        IDataSourceGetter dataSourceGetter = (IDataSourceGetter)SpringContextUtil.getBean(IDataSourceGetter.class);
        boolean defaultField = tableFieldGetter instanceof DefaultTableFieldGetter;
        boolean defaultSource = dataSourceGetter instanceof DefaultDataSourceGetter;
        if (!defaultField && !defaultSource) {
            return;
        }
        log.info("\u6570\u636e\u6e90\u4fe1\u606f\u521d\u59cb\u5316 >>>> ");
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        try (Connection connection = dataSource.getConnection();){
            String url = connection.getMetaData().getURL();
            connection.createStatement().execute(DDL_SQL_PERFORMANCE);
            DatabaseInfo info = DatabaseUtils.parseUrl(url);
            if (defaultField) {
                List<TableInfo> tableInfos = this.tableInfoMapper.tableInfo(info.getDatabaseName());
                for (TableInfo tableInfo : tableInfos) {
                    tableInfo.setIp(info.getIp());
                    tableInfo.setPort(info.getPort());
                    tableInfo.setDatabaseName(info.getDatabaseName());
                }
                isTenantId = tableInfos.stream().filter(e -> e.getFieldName().equals("tenant_id")).findAny().isPresent();
                ((DefaultTableFieldGetter)tableFieldGetter).saveCache(tableInfos);
                log.info(">>>> \u6570\u636e\u8868\u52a0\u8f7d\u5b8c\u6bd5, \u5171{}\u4e2a\u8868\u5b57\u6bb5", (Object)tableInfos.size());
            }
            if (defaultSource) {
                log.info(">>>> \u6570\u636e\u6e90\u52a0\u8f7d\u5b8c\u6bd5, \u51711\u4e2a\u6570\u636e\u6e90");
                ((DefaultDataSourceGetter)dataSourceGetter).init(info);
            }
        }
        catch (Exception e2) {
            log.error(">>>> \u6570\u636e\u6e90\u4fe1\u606f\u521d\u59cb\u5316\u5f02\u5e38, \u90e8\u5206\u529f\u80fd\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528", (Throwable)e2);
        }
    }

    public static Boolean getIsTenantId() {
        return isTenantId;
    }
}

