/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.getter;

import cn.bctools.database.entity.TableInfo;
import cn.bctools.database.getter.ITableFieldGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableFieldGetter
implements ITableFieldGetter {
    private static final Logger log = LoggerFactory.getLogger(DefaultTableFieldGetter.class);
    private final Map<String, List<String>> tableInfoCache = new HashMap<String, List<String>>(256);
    private static final Set<String> tableList = new HashSet<String>(3);

    @Override
    public List<String> getFieldNames(String ip, String port, String databaseName, String tableName) {
        String key = this.getKey(ip, port, databaseName, tableName);
        List<String> fieldNames = this.tableInfoCache.get(key);
        if (Objects.isNull(fieldNames)) {
            fieldNames = Collections.emptyList();
        }
        return fieldNames;
    }

    public void saveCache(@NotNull List<TableInfo> tableInfo) {
        for (TableInfo info : tableInfo) {
            String key = this.getKey(info.getIp(), info.getPort(), info.getDatabaseName(), info.getTableName());
            List fieldNames = this.tableInfoCache.computeIfAbsent(key, e -> new ArrayList());
            fieldNames.add(info.getFieldName());
            if (!info.getFieldName().equals("tenant_id")) continue;
            tableList.add(info.getTableName());
        }
    }

    private String getKey(String ip, String port, String databaseName, String tableName) {
        return String.format("%s:%s:%s:%s", ip, port, databaseName, tableName);
    }

    public static Set<String> getTableList() {
        return tableList;
    }
}

