/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.config;

import cn.bctools.common.utils.SpringContextUtil;
import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.database.entity.DatabaseInfo;
import cn.bctools.database.getter.DefaultTableFieldGetter;
import cn.bctools.database.interceptor.datascope.DataScopeInterceptor;
import cn.bctools.database.interceptor.datascope.DataSourceExpressionHandlerImpl;
import cn.bctools.database.interceptor.datascope.IDataSourceExpressionHandler;
import cn.bctools.database.interceptor.other.CustomOthersInterceptor;
import cn.bctools.database.interceptor.performance.SQLPerformanceInterceptor;
import cn.bctools.database.interceptor.tenant.JvsTenantHandler;
import cn.bctools.database.interceptor.tenant.JvsTenantLineInnerInterceptor;
import cn.bctools.database.property.SqlProperties;
import cn.bctools.database.util.DatabaseUtils;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@MapperScan(basePackages={"cn.bctools.**.mapper"})
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public IDataSourceExpressionHandler dataSourceExpressionHandler() {
        return new DataSourceExpressionHandlerImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataScopeInterceptor dataScopeInterceptor() {
        DataScopeInterceptor dataScopeInterceptor = new DataScopeInterceptor();
        dataScopeInterceptor.setDataSourceExpressionHandler(this.dataSourceExpressionHandler());
        return dataScopeInterceptor;
    }

    @Autowired
    void tenantInit(NacosDiscoveryProperties nacosDiscoveryProperties) {
        nacosDiscoveryProperties.getMetadata().put("tenantDynamicDatasource", "open");
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor() {
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor(){

            protected String changeTable(String sql) {
                TableNameParser parser = new TableNameParser(sql);
                ArrayList names = new ArrayList();
                parser.accept(names::add);
                StringBuilder builder = new StringBuilder();
                int last = 0;
                for (TableNameParser.SqlToken name : names) {
                    int start = name.getStart();
                    if (start != last) {
                        builder.append(sql, last, start);
                        String value = name.getValue();
                        if (DefaultTableFieldGetter.getTableList().contains(value)) {
                            builder.append(this.dynamicTableName(sql, value));
                        } else {
                            builder.append(value);
                        }
                    }
                    last = name.getEnd();
                }
                if (last != sql.length()) {
                    builder.append(sql.substring(last));
                }
                return builder.toString();
            }

            private String dynamicTableName(String sql, String tableName) {
                String tenantId = TenantContextHolder.getTenantId();
                if (StrUtil.isBlank((CharSequence)tenantId)) {
                    return tableName;
                }
                SqlProperties sqlProperties = (SqlProperties)SpringContextUtil.getBean(SqlProperties.class);
                if (!sqlProperties.isDynamicTenantDatabase()) {
                    return tableName;
                }
                try {
                    DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
                    String url = dataSource.getConnection().getMetaData().getURL();
                    DatabaseInfo info = DatabaseUtils.parseUrl(url);
                    tableName = info.getDatabaseName() + "_" + tenantId + "." + tableName;
                }
                catch (SQLException throwables) {
                    log.error("SQL\u521d\u59cb\u5316\u9519\u8bef", (Throwable)throwables);
                }
                return tableName;
            }
        };
        return dynamicTableNameInnerInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public JvsTenantLineInnerInterceptor jvsTenantLineInnerInterceptor(JvsTenantHandler jvsTenantHandler) {
        return new JvsTenantLineInnerInterceptor(jvsTenantHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public CustomOthersInterceptor otherInterceptor(final DataScopeInterceptor dataScope, final JvsTenantLineInnerInterceptor jvsTenant, final DynamicTableNameInnerInterceptor table) {
        return new CustomOthersInterceptor(){

            @Override
            public List<InnerInterceptor> gets() {
                return this.init(new InnerInterceptor[]{dataScope, jvsTenant, table, new BlockAttackInnerInterceptor(), new PaginationInnerInterceptor(DbType.MYSQL)});
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public JvsTenantHandler tenantHandler() {
        return new JvsTenantHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public SQLPerformanceInterceptor sqlInterceptorConfig() {
        return new SQLPerformanceInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor(CustomOthersInterceptor customOthersInterceptor) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        List<InnerInterceptor> gets = customOthersInterceptor.gets();
        if (ObjectUtil.isNotEmpty(gets)) {
            for (InnerInterceptor get : gets) {
                interceptor.addInnerInterceptor(get);
            }
        }
        return interceptor;
    }
}

