/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.config;

import cn.bctools.database.controller.TenantDynamicDatasource;
import cn.bctools.database.getter.DefaultDataSourceGetter;
import cn.bctools.database.getter.DefaultTableFieldGetter;
import cn.bctools.database.getter.IDataSourceGetter;
import cn.bctools.database.getter.ITableFieldGetter;
import cn.bctools.database.init.DataSourceInit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;

public class DatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public ITableFieldGetter tableFieldGetter() {
        log.info("[mysql-data] \u4f7f\u7528\u9ed8\u8ba4\u7684\u8868\u5b57\u6bb5\u83b7\u53d6\u7c7b: {}", (Object)DefaultTableFieldGetter.class.getName());
        return new DefaultTableFieldGetter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"cn.bctools.dynamic.config.DynamicDataConfig"})
    public IDataSourceGetter dataSourceGetter() {
        log.info("[mysql-data] \u4f7f\u7528\u9ed8\u8ba4\u7684\u6570\u636e\u6e90\u4fe1\u606f\u83b7\u53d6\u7c7b: {}", (Object)DefaultDataSourceGetter.class.getName());
        return new DefaultDataSourceGetter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"cn.bctools.dynamic.config.DynamicDataConfig"})
    public DataSourceInit dataSourceInit() {
        log.info("[mysql-data] \u52a0\u8f7d\u5355\u6570\u636e\u6e90\u521d\u59cb\u5316\u7c7b: {}", (Object)DataSourceInit.class.getName());
        return new DataSourceInit();
    }

    @Bean
    @ConditionalOnMissingBean
    TenantDynamicDatasource mycatController(DataSource dataSource, IDataSourceGetter dataSourceGetter, ITableFieldGetter tableFieldGetter) {
        return new TenantDynamicDatasource(dataSourceGetter, tableFieldGetter, dataSource);
    }
}

