/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.database.config;

import cn.bctools.common.entity.dto.UserDto;
import cn.bctools.common.entity.dto.UserInfoDto;
import cn.bctools.common.utils.SystemThreadLocal;
import cn.bctools.common.utils.function.Get;
import cn.bctools.database.entity.po.BasalPo;
import cn.bctools.database.entity.po.BasePo;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

@ConditionalOnMissingBean(value={MetaObjectHandler.class})
public class AutoFillConfig
implements MetaObjectHandler {
    public void insertFill(MetaObject metaObject) {
        LocalDateTime now = LocalDateTime.now();
        this.strictInsertFill(metaObject, Get.name(BasalPo::getCreateTime), () -> now, LocalDateTime.class);
        this.strictInsertFill(metaObject, Get.name(BasalPo::getUpdateTime), () -> now, LocalDateTime.class);
        UserInfoDto user = (UserInfoDto)SystemThreadLocal.get((String)"user");
        if (ObjectUtil.isNotEmpty((Object)user)) {
            UserDto userDto = user.getUserDto();
            this.strictInsertFill(metaObject, Get.name(BasePo::getDeptId), () -> ((UserDto)userDto).getDeptId(), String.class);
            this.strictInsertFill(metaObject, Get.name(BasePo::getJobId), () -> ((UserDto)userDto).getJobId(), String.class);
            this.strictInsertFill(metaObject, Get.name(BasalPo::getCreateBy), () -> ((UserDto)userDto).getRealName(), String.class);
            this.strictInsertFill(metaObject, Get.name(BasalPo::getUpdateBy), () -> ((UserDto)userDto).getRealName(), String.class);
            this.strictInsertFill(metaObject, Get.name(BasalPo::getCreateById), () -> ((UserDto)userDto).getId(), String.class);
        }
    }

    public void updateFill(MetaObject metaObject) {
        metaObject.setValue(Get.name(BasalPo::getUpdateTime), (Object)LocalDateTime.now());
        UserInfoDto user = (UserInfoDto)SystemThreadLocal.get((String)"user");
        if (ObjectUtil.isNotEmpty((Object)user)) {
            UserDto userDto = user.getUserDto();
            this.strictUpdateFill(metaObject, Get.name(BasalPo::getUpdateBy), () -> ((UserDto)userDto).getRealName(), String.class);
        }
    }
}

