/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserTenant;
import cn.bctools.auth.mapper.UserExtensionMapper;
import cn.bctools.auth.mapper.UserMapper;
import cn.bctools.auth.mapper.UserRoleMapper;
import cn.bctools.auth.mapper.UserTenantMapper;
import cn.bctools.auth.service.UserService;
import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.TenantContextHolder;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class UserServiceImpl
extends ServiceImpl<UserMapper, User>
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    UserMapper userMapper;
    UserRoleMapper userRoleMapper;
    UserTenantMapper userTenantMapper;
    UserExtensionMapper userExtensionMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public User saveUser(User user, UserTenant userTenant) {
        String phone = user.getPhone();
        int count = this.count((Wrapper)Wrappers.lambdaQuery().eq(User::getPhone, (Object)phone));
        if (count > 0) {
            throw new BusinessException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        this.save(user);
        userTenant.setUserId(user.getId());
        this.userTenantMapper.insert(userTenant);
        return (User)this.getById((Serializable)((Object)user.getId()));
    }

    @Override
    public User info(String username) {
        log.debug("\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55, \u7528\u6237\u540d: {}, \u9009\u62e9\u767b\u5f55\u79df\u6237id: {}", (Object)username, (Object)TenantContextHolder.getTenantId());
        User user = (User)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(User::getAccountName, (Object)username));
        if (ObjectUtil.isEmpty((Object)user)) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (user.getCancelFlag().booleanValue()) {
            throw new BusinessException("\u7528\u6237\u5df2\u88ab\u6ce8\u9500, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return user;
    }

    @Override
    public List<User> getByRoleIds(List<String> roleIds) {
        if (ObjectUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder("(");
        for (String roleId : roleIds) {
            if (StringUtils.isBlank((CharSequence)roleId)) {
                return Collections.emptyList();
            }
            builder.append(roleId).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        List<User> userList = this.userMapper.getByRoleIds(builder.toString());
        if (userList.isEmpty()) {
            return Collections.emptyList();
        }
        return userList;
    }

    @Override
    public List<User> getQueryDeptName(String deptName) {
        return this.userMapper.getQueryDeptName(deptName);
    }

    @Override
    public User phone(String phone) {
        User user = (User)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(User::getPhone, (Object)phone));
        if (ObjectUtil.isEmpty((Object)user)) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getCancelFlag().booleanValue()) {
            throw new BusinessException("\u7528\u6237\u5df2\u88ab\u6ce8\u9500, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return user;
    }

    @Override
    public <T> boolean updateInfo(SFunction<User, T> getter, T value, String userId) {
        if (Objects.isNull(getter) || StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        return this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(getter, value)).eq(User::getId, (Object)userId));
    }

    public UserServiceImpl(UserMapper userMapper, UserRoleMapper userRoleMapper, UserTenantMapper userTenantMapper, UserExtensionMapper userExtensionMapper) {
        this.userMapper = userMapper;
        this.userRoleMapper = userRoleMapper;
        this.userTenantMapper = userTenantMapper;
        this.userExtensionMapper = userExtensionMapper;
    }
}

