/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.api.enums.SysRoleEnum;
import cn.bctools.auth.entity.Role;
import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserRole;
import cn.bctools.auth.mapper.RoleMapper;
import cn.bctools.auth.mapper.UserMapper;
import cn.bctools.auth.mapper.UserRoleMapper;
import cn.bctools.auth.service.UserRoleService;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRoleServiceImpl
extends ServiceImpl<UserRoleMapper, UserRole>
implements UserRoleService {
    private static final Logger log = LoggerFactory.getLogger(UserRoleServiceImpl.class);
    RoleMapper roleMapper;
    UserMapper userMapper;

    @Override
    public List<Role> getRoleByUserId(String userId) {
        List list = this.list((Wrapper)Wrappers.query((Object)new UserRole().setUserId(userId)));
        if (ObjectUtil.isNotEmpty((Object)list)) {
            List collect = list.stream().map(UserRole::getRoleId).collect(Collectors.toList());
            return this.roleMapper.selectBatchIds(collect);
        }
        return Collections.emptyList();
    }

    @Override
    public List<User> getUsersByRoleId(String roleId) {
        List list = this.list((Wrapper)Wrappers.query((Object)new UserRole().setRoleId(roleId)));
        if (ObjectUtil.isNotEmpty((Object)list)) {
            List collect = list.stream().map(UserRole::getUserId).collect(Collectors.toList());
            return this.userMapper.selectBatchIds(collect);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grandDefaultSysRole(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            log.warn("[\u8d4b\u4e88\u9ed8\u8ba4\u89d2\u8272] \u64cd\u4f5c\u5931\u8d25, \u7528\u6237id\u4e3a\u7a7a");
            return;
        }
        List roleList = this.roleMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(Role::getRoleName, (Collection)SysRoleEnum.getAutoGrantNames()));
        if (ObjectUtils.isEmpty((Object)roleList)) {
            log.warn("[\u8d4b\u4e88\u9ed8\u8ba4\u89d2\u8272] \u64cd\u4f5c\u5931\u8d25, \u6709\u627e\u5230\u9ed8\u8ba4\u89d2\u8272");
            return;
        }
        List userRoleList = roleList.stream().map(role -> new UserRole().setUserId(userId).setRoleId(role.getId())).collect(Collectors.toList());
        this.saveBatch(userRoleList);
    }

    @Override
    public void clearUser(@NotNull String userId) {
        this.remove((Wrapper)Wrappers.lambdaQuery().eq(UserRole::getUserId, (Object)userId));
    }

    public UserRoleServiceImpl(RoleMapper roleMapper, UserMapper userMapper) {
        this.roleMapper = roleMapper;
        this.userMapper = userMapper;
    }
}

