/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.entity.TenantPo;
import cn.bctools.auth.mapper.TenantMapper;
import cn.bctools.auth.service.TenantService;
import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.common.utils.TreeUtils;
import cn.hutool.core.util.ReUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantServiceImpl
extends ServiceImpl<TenantMapper, TenantPo>
implements TenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    TenantMapper tenantMapper;

    @Override
    public List<TenantPo> getChild() {
        String tenantId = TenantContextHolder.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            return Collections.emptyList();
        }
        List tenantList = this.list();
        return TreeUtils.getListPassingBy((Collection)tenantList, (Object)tenantId, TenantPo::getId, TenantPo::getParentId);
    }

    @Override
    public Optional<TenantPo> getTenantIdFromHost(String loginDomain, Set<String> tenantIds) {
        if (StringUtils.isBlank((CharSequence)loginDomain)) {
            return Optional.empty();
        }
        String domain = ReUtil.getGroup0((String)"(?<=://).*?(?=.jvs.bctools.cn)", (CharSequence)loginDomain);
        List tenantPo = this.tenantMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(TenantPo::getLoginDomain, (Object)domain)).in(CollectionUtils.isNotEmpty(tenantIds), TenantPo::getId, tenantIds));
        if (ObjectUtils.isNotNull((Object[])new Object[]{tenantPo})) {
            return Optional.ofNullable(tenantPo.get(0));
        }
        return Optional.empty();
    }

    public TenantServiceImpl(TenantMapper tenantMapper) {
        this.tenantMapper = tenantMapper;
    }
}

