/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.entity.SysTree;
import cn.bctools.auth.mapper.SysTreeMapper;
import cn.bctools.auth.service.SysTreeService;
import cn.bctools.common.exception.BusinessException;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysTreeImpl
extends ServiceImpl<SysTreeMapper, SysTree>
implements SysTreeService {
    private static final Logger log = LoggerFactory.getLogger(SysTreeImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTree(String id) {
        SysTree sysTree = (SysTree)this.getById((Serializable)((Object)id));
        String parentId = sysTree.getParentId();
        String groupId = sysTree.getGroupId();
        if ("-1".equals(parentId)) {
            this.remove((Wrapper)Wrappers.lambdaQuery().eq(SysTree::getGroupId, (Object)groupId));
        } else {
            List<String> childIds = this.getChild(id, null);
            this.removeByIds(childIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void checkName(String name, String parentId) {
        int count = this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysTree::getName, (Object)name)).eq(SysTree::getParentId, (Object)parentId));
        if (count > 0) {
            log.error("[\u6811\u5f62\u5b57\u5178] \u540c\u4e00\u5c42\u7ea7\u7684\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u91cd\u590d, name: {}, id: {}", (Object)name, (Object)parentId);
            throw new BusinessException("\u540c\u4e00\u5c42\u7ea7\u7684\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u91cd\u590d: {}", new Object[]{name});
        }
    }

    private List<String> getChild(String id, List<String> ids) {
        if (ids == null) {
            ids = new ArrayList<String>();
        }
        if (id == null) {
            return null;
        }
        ids.add(id);
        List list = this.list((Wrapper)Wrappers.query((Object)new SysTree().setParentId(id)));
        if (ObjectUtil.isNotEmpty((Object)list)) {
            for (SysTree sysTree : list) {
                String sysTreeId = sysTree.getId();
                this.getChild(sysTreeId, ids);
            }
        }
        return ids;
    }
}

