/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.entity.SysDict;
import cn.bctools.auth.entity.SysDictItem;
import cn.bctools.auth.entity.enums.DictTypeEnum;
import cn.bctools.auth.mapper.SysDictItemMapper;
import cn.bctools.auth.mapper.SysDictMapper;
import cn.bctools.auth.service.SysDictService;
import cn.bctools.common.exception.BusinessException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysDictServiceImpl
extends ServiceImpl<SysDictMapper, SysDict>
implements SysDictService {
    private static final Logger log = LoggerFactory.getLogger(SysDictServiceImpl.class);
    private final SysDictItemMapper dictItemMapper;

    @Override
    @CacheEvict(value={"dict_details"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void removeDict(String id) {
        SysDict dict = (SysDict)this.getById((Serializable)((Object)id));
        if (Objects.isNull(dict)) {
            return;
        }
        if (DictTypeEnum.SYSTEM.equals((Object)dict.getSystem())) {
            throw new BusinessException("\u7cfb\u7edf\u5185\u7f6e\u5b57\u5178\u4e0d\u80fd\u5220\u9664");
        }
        ((SysDictMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.dictItemMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysDictItem::getDictId, (Object)id));
    }

    @Override
    public void updateDict(SysDict dict) {
        SysDict sysDict = (SysDict)this.getById((Serializable)((Object)dict.getId()));
        if (Objects.isNull(sysDict)) {
            throw new BusinessException("\u8be5\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        if (!sysDict.getType().equals(dict.getType())) {
            Assert.isTrue((this.count((Wrapper)Wrappers.lambdaQuery().eq(SysDict::getType, (Object)dict.getType())) <= 0 ? 1 : 0) != 0, (String)String.format("\u8be5\u7c7b\u578b%s\u5b57\u5178\u5df2\u7ecf\u5b58\u5728\u4e86", dict.getType()));
        }
        this.updateById(dict);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveDict(SysDict sysDict) {
        String type = sysDict.getType();
        Assert.isTrue((this.count((Wrapper)Wrappers.lambdaQuery().eq(SysDict::getType, (Object)type)) <= 0 ? 1 : 0) != 0, (String)String.format("\u8be5\u7c7b\u578b%s\u5b57\u5178\u5df2\u7ecf\u5b58\u5728\u4e86", type));
        this.save(sysDict);
        return sysDict.getId();
    }

    @Override
    public List<SysDictItem> getDictByType(String type) {
        List list = this.dictItemMapper.selectList((Wrapper)Wrappers.query().lambda().eq(SysDictItem::getType, (Object)type));
        if (!list.isEmpty()) {
            return list;
        }
        return new ArrayList<SysDictItem>();
    }

    public SysDictServiceImpl(SysDictItemMapper dictItemMapper) {
        this.dictItemMapper = dictItemMapper;
    }
}

