/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.entity.Menu;
import cn.bctools.auth.entity.Permission;
import cn.bctools.auth.entity.RolePermission;
import cn.bctools.auth.entity.enums.RolePermissionEnum;
import cn.bctools.auth.mapper.RolePermissionMapper;
import cn.bctools.auth.service.MenuService;
import cn.bctools.auth.service.PermissionService;
import cn.bctools.auth.service.RolePermissionService;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RolePermissionServiceImpl
extends ServiceImpl<RolePermissionMapper, RolePermission>
implements RolePermissionService {
    private static final Logger log = LoggerFactory.getLogger(RolePermissionServiceImpl.class);
    MenuService menuService;
    PermissionService permissionService;

    @Override
    public List<Menu> getMenuRoleById(List<String> roleId) {
        List<String> ids = this.getIds(RolePermissionEnum.menu, roleId);
        if (ObjectUtil.isNotEmpty(ids)) {
            List menus = this.menuService.listByIds(ids);
            return menus;
        }
        return new ArrayList<Menu>();
    }

    @Override
    public List<Permission> getFunctionRoleById(List<String> roleId) {
        List<String> ids = this.getIds(RolePermissionEnum.button, roleId);
        if (ObjectUtil.isEmpty(ids)) {
            return new ArrayList<Permission>();
        }
        List<Permission> permissionData = this.permissionService.listByIds(ids).stream().distinct().collect(Collectors.toList());
        return permissionData;
    }

    protected List<String> getIds(RolePermissionEnum rolePermissionEnum, List<String> roleIds) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RolePermission::getType, (Object)rolePermissionEnum)).in(RolePermission::getRoleId, roleIds));
        List<String> dataPermissionIds = list.stream().map(RolePermission::getPermissionId).distinct().collect(Collectors.toList());
        return dataPermissionIds;
    }

    public RolePermissionServiceImpl(MenuService menuService, PermissionService permissionService) {
        this.menuService = menuService;
        this.permissionService = permissionService;
    }
}

