/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.entity.Job;
import cn.bctools.auth.mapper.JobMapper;
import cn.bctools.auth.service.JobService;
import cn.bctools.common.exception.BusinessException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImpl
extends ServiceImpl<JobMapper, Job>
implements JobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);

    @Override
    public Job checkId(String jobId) {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            throw new BusinessException("\u5c97\u4f4did\u4e3a\u7a7a, \u64cd\u4f5c\u5931\u8d25");
        }
        Job job = (Job)this.getById((Serializable)((Object)jobId));
        if (Objects.isNull(job)) {
            log.error("\u8be5\u5c97\u4f4d\u4e0d\u5b58\u5728, \u5c97\u4f4did: {}", (Object)jobId);
            throw new BusinessException("\u8be5\u5c97\u4f4d\u4e0d\u5b58\u5728");
        }
        return job;
    }

    @Override
    public void checkJobName(String jobName) {
        this.checkJobName(jobName, null);
    }

    @Override
    public void checkJobName(String jobName, String excludeJobId) {
        if (StringUtils.isBlank((CharSequence)jobName)) {
            throw new BusinessException("\u5c97\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        }
        int count = this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Job::getName, (Object)jobName)).ne(StringUtils.isNotBlank((CharSequence)excludeJobId), Job::getId, (Object)excludeJobId));
        if (count > 0) {
            throw new BusinessException("\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }
}

