/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.service.impl;

import cn.bctools.auth.comparator.UriPatternComparator;
import cn.bctools.auth.entity.SysData;
import cn.bctools.auth.entity.SysDataRole;
import cn.bctools.auth.mapper.DataMapper;
import cn.bctools.auth.mapper.DataRoleMapper;
import cn.bctools.auth.service.DataRoleService;
import cn.bctools.common.entity.dto.DataApiDto;
import cn.bctools.common.entity.dto.DataScopeDto;
import cn.bctools.common.utils.BeanCopyUtil;
import cn.bctools.common.utils.ObjectNull;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DataRoleServiceImpl
extends ServiceImpl<DataRoleMapper, SysDataRole>
implements DataRoleService {
    DataMapper dataMapper;

    @Override
    public List<DataScopeDto> queryUserPermission(List<String> roleIds) {
        if (ObjectUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        List dataRoleList = this.list((Wrapper)Wrappers.lambdaQuery().in(SysDataRole::getRoleId, roleIds));
        if (ObjectUtils.isEmpty((Object)dataRoleList)) {
            return Collections.emptyList();
        }
        Set dataIds = dataRoleList.stream().map(SysDataRole::getDataId).collect(Collectors.toSet());
        List sysDataList = this.dataMapper.selectBatchIds(dataIds);
        Map<String, SysData> sysDataMap = sysDataList.stream().collect(Collectors.toMap(SysData::getId, e -> e));
        ArrayList<DataScopeDto> dataScopeList = new ArrayList<DataScopeDto>();
        for (SysDataRole dataRole : dataRoleList) {
            DataApiDto dataApiDto;
            DataScopeDto scopeDto = dataRole.getRemark();
            SysData sysData = sysDataMap.get(dataRole.getDataId());
            if (!ObjectNull.isNotNull((Object[])new Object[]{sysData}) || !StringUtils.isNotBlank((CharSequence)(dataApiDto = (DataApiDto)BeanCopyUtil.copy((Object)sysData, DataApiDto.class)).getApi())) continue;
            scopeDto.setDataApi(dataApiDto);
            dataScopeList.add(scopeDto);
        }
        dataScopeList.sort((a, b) -> new UriPatternComparator().compare(a.getDataApi().getApi(), b.getDataApi().getApi()));
        return dataScopeList;
    }

    public DataRoleServiceImpl(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
    }
}

