/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.login;

import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserExtension;
import cn.bctools.auth.entity.UserTenant;
import cn.bctools.auth.login.LoginHandler;
import cn.bctools.auth.service.RoleService;
import cn.bctools.auth.service.UserExtensionService;
import cn.bctools.auth.service.UserRoleService;
import cn.bctools.auth.service.UserService;
import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.IdGenerator;
import cn.bctools.common.utils.PasswordUtil;
import cn.bctools.oss.dto.BaseFile;
import cn.bctools.oss.template.OssTemplate;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xkcoding.justauth.AuthRequestFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthWeChatOpenRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="WECHAT_OPEN")
public class WxLoginHandler
implements LoginHandler<AuthCallback> {
    private static final Logger log = LoggerFactory.getLogger(WxLoginHandler.class);
    OssTemplate ossTemplate;
    AuthRequestFactory factory;
    RoleService roleService;
    UserService userService;
    UserRoleService userRoleService;
    UserExtensionService userExtensionService;

    @Override
    public User handle(String code, String appId, AuthCallback callback) {
        User user;
        AuthWeChatOpenRequest authRequest = (AuthWeChatOpenRequest)this.factory.get(AuthDefaultSource.WECHAT_OPEN.name());
        AuthResponse response = authRequest.login(callback);
        if (!response.ok()) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u4fe1\u606f\u9519\u8bef: {}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5fae\u4fe1\u4fe1\u606f\u9519\u8bef");
        }
        log.info("[login] \u83b7\u53d6\u5fae\u4fe1\u4fe1\u606f: {}", (Object)JSONUtil.toJsonStr((Object)response));
        AuthUser authUser = (AuthUser)response.getData();
        String nickname = authUser.getNickname();
        String openId = authUser.getToken().getOpenId();
        String avatar = this.getDurableAvatar(nickname, authUser.getAvatar());
        UserExtension extension = (UserExtension)this.userExtensionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserExtension::getType, (Object)AuthDefaultSource.WECHAT_OPEN.name())).eq(UserExtension::getOpenId, (Object)openId));
        if (ObjectUtil.isEmpty((Object)extension)) {
            user = new User().setHeadImg(avatar).setRealName(nickname).setAccountName(IdGenerator.getIdStr((int)36)).setCancelFlag(false);
            UserTenant userTenant = new UserTenant().setRealName(nickname).setCancelFlag(false);
            this.userService.saveUser(user, userTenant);
            UserExtension userExtension = new UserExtension().setExtension(BeanUtil.beanToMap((Object)authUser)).setOpenId(openId).setNickname(nickname).setType(AuthDefaultSource.WECHAT_OPEN.name()).setUserId(user.getId());
            this.userExtensionService.save(userExtension);
            this.userRoleService.grandDefaultSysRole(user.getId());
        } else {
            extension.setExtension(BeanUtil.beanToMap((Object)authUser));
            extension.setNickname(nickname);
            this.userExtensionService.updateById(extension);
            user = (User)this.userService.getById((Serializable)((Object)extension.getUserId()));
            user.setHeadImg(avatar);
            this.userService.updateById(user);
        }
        return user;
    }

    @Override
    public void bind(User user, String code, String appId) {
        String decodedPassword = PasswordUtil.decodedPassword((String)code, (String)appId);
        AuthCallback callback = (AuthCallback)JSONObject.parseObject((String)decodedPassword, AuthCallback.class);
        AuthWeChatOpenRequest authRequest = (AuthWeChatOpenRequest)this.factory.get(AuthDefaultSource.WECHAT_OPEN.name());
        AuthResponse response = authRequest.login(callback);
        log.info("[bind] \u83b7\u53d6\u5fae\u4fe1\u4fe1\u606f: {}", (Object)JSONUtil.toJsonStr((Object)response));
        AuthUser authUser = (AuthUser)response.getData();
        String nickname = authUser.getNickname();
        String openId = authUser.getToken().getOpenId();
        String avatar = this.getDurableAvatar(nickname, authUser.getAvatar());
        user.setHeadImg(avatar);
        UserExtension extension = (UserExtension)this.userExtensionService.getOne((Wrapper)Wrappers.query((Object)new UserExtension().setType(AuthDefaultSource.WECHAT_OPEN.getName()).setOpenId(openId)));
        if (ObjectUtil.isNotEmpty((Object)extension)) {
            throw new BusinessException("\u5fae\u4fe1\u5df2\u7ed1\u5b9a\u5176\u5b83\u5e10\u53f7");
        }
        extension = new UserExtension().setOpenId(openId).setNickname(nickname).setUserId(user.getId()).setType(AuthDefaultSource.WECHAT_OPEN.name()).setExtension((Map<String, Object>)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authUser)));
        this.userService.updateById(user);
        this.userExtensionService.save(extension);
    }

    private String getDurableAvatar(String nickname, String fileUrl) {
        byte[] bytes = HttpUtil.downloadBytes((String)fileUrl);
        BaseFile baseFile = this.ossTemplate.putFile("jvs-public", "/wx/avatar", nickname + ".jpg", (InputStream)new ByteArrayInputStream(bytes));
        return this.ossTemplate.fileLink(baseFile.getFileName(), "jvs-public");
    }

    public WxLoginHandler(OssTemplate ossTemplate, AuthRequestFactory factory, RoleService roleService, UserService userService, UserRoleService userRoleService, UserExtensionService userExtensionService) {
        this.ossTemplate = ossTemplate;
        this.factory = factory;
        this.roleService = roleService;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.userExtensionService = userExtensionService;
    }
}

