/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.login;

import cn.bctools.auth.component.SmsEmailComponent;
import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserExtension;
import cn.bctools.auth.entity.UserTenant;
import cn.bctools.auth.login.LoginHandler;
import cn.bctools.auth.login.dto.WxAppDto;
import cn.bctools.auth.service.RoleService;
import cn.bctools.auth.service.UserExtensionService;
import cn.bctools.auth.service.UserRoleService;
import cn.bctools.auth.service.UserService;
import cn.bctools.auth.service.UserTenantService;
import cn.bctools.common.utils.IdGenerator;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="wxapp")
public class WxAppLoginHandler
implements LoginHandler<WxAppDto> {
    private static final Logger log = LoggerFactory.getLogger(WxAppLoginHandler.class);
    UserService userService;
    UserTenantService userTenantService;
    SmsEmailComponent smsComponent;
    RoleService roleService;
    UserRoleService userRoleService;
    UserExtensionService userExtensionService;

    @Override
    public User handle(String code, String appId, WxAppDto wxAppDto) {
        UserExtension wxapp = new UserExtension().setType("wxapp").setOpenId(wxAppDto.getOpenId());
        wxapp.setNickname(wxAppDto.getNickname());
        UserExtension userExtension = (UserExtension)this.userExtensionService.getOne((Wrapper)Wrappers.lambdaQuery((Object)wxapp));
        if (ObjectUtil.isNotEmpty((Object)userExtension)) {
            return (User)this.userService.getById((Serializable)((Object)userExtension.getUserId()));
        }
        String idStr = IdGenerator.getIdStr((int)36);
        User user = new User().setAccountName(IdGenerator.getIdStr((int)36)).setRealName(idStr);
        user.setCancelFlag(false);
        UserTenant userTenant = new UserTenant().setRealName(idStr);
        this.userService.saveUser(user, userTenant);
        this.userRoleService.grandDefaultSysRole(user.getId());
        wxapp.setUserId(user.getId());
        this.userExtensionService.save(wxapp);
        return user;
    }

    @Override
    public void bind(User user, String code, String appId) {
    }

    public WxAppLoginHandler(UserService userService, UserTenantService userTenantService, SmsEmailComponent smsComponent, RoleService roleService, UserRoleService userRoleService, UserExtensionService userExtensionService) {
        this.userService = userService;
        this.userTenantService = userTenantService;
        this.smsComponent = smsComponent;
        this.roleService = roleService;
        this.userRoleService = userRoleService;
        this.userExtensionService = userExtensionService;
    }
}

