/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.login;

import cn.bctools.auth.component.SmsEmailComponent;
import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserTenant;
import cn.bctools.auth.login.LoginHandler;
import cn.bctools.auth.login.dto.RegisterDto;
import cn.bctools.auth.service.RoleService;
import cn.bctools.auth.service.UserRoleService;
import cn.bctools.auth.service.UserService;
import cn.bctools.auth.service.UserTenantService;
import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.IdGenerator;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="register")
public class RegisterLoginHandler
implements LoginHandler<RegisterDto> {
    private static final Logger log = LoggerFactory.getLogger(RegisterLoginHandler.class);
    UserService userService;
    UserTenantService userTenantService;
    SmsEmailComponent smsComponent;
    RoleService roleService;
    UserRoleService userRoleService;
    static final Pattern WORD_PATTERN = Pattern.compile("^[A-Za-z]+$");

    @Override
    public User handle(String code, String appId, RegisterDto registerDto) {
        this.smsComponent.check(registerDto.getPhone(), registerDto.getCode(), () -> new BusinessException("\u9a8c\u8bc1\u5931\u8d25"));
        User user = new User().setPhone(registerDto.getPhone()).setRealName(registerDto.getRealName());
        user.setAccountName(IdGenerator.getIdStr((int)36));
        if (ObjectUtil.isEmpty((Object)this.userService.getOne((Wrapper)Wrappers.lambdaQuery((Object)new User().setRealName(registerDto.getRealName())))) && WORD_PATTERN.matcher(registerDto.getRealName()).matches()) {
            user.setAccountName(registerDto.getRealName());
        }
        user.setCancelFlag(false);
        UserTenant userTenant = new UserTenant().setRealName(registerDto.getRealName());
        this.userService.saveUser(user, userTenant);
        this.userRoleService.grandDefaultSysRole(user.getId());
        return user;
    }

    @Override
    public void bind(User user, String code, String appId) {
    }

    public RegisterLoginHandler(UserService userService, UserTenantService userTenantService, SmsEmailComponent smsComponent, RoleService roleService, UserRoleService userRoleService) {
        this.userService = userService;
        this.userTenantService = userTenantService;
        this.smsComponent = smsComponent;
        this.roleService = roleService;
        this.userRoleService = userRoleService;
    }
}

